/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.load.BaseLoader;
import org.yarnandtail.andhow.load.KVP;

public class StringArgumentLoader
extends BaseLoader {
    public static final String KVP_DELIMITER = "=";
    private final List<String> cmdLineArgs;

    public StringArgumentLoader(List<String> inCmdLineArgs) {
        if (inCmdLineArgs != null && inCmdLineArgs.size() > 0) {
            this.cmdLineArgs = new ArrayList<String>();
            this.cmdLineArgs.addAll(inCmdLineArgs);
        } else {
            this.cmdLineArgs = Collections.emptyList();
        }
    }

    public StringArgumentLoader(String[] inCmdLineArgs) {
        this.cmdLineArgs = inCmdLineArgs != null && inCmdLineArgs.length > 0 ? Arrays.asList(inCmdLineArgs) : Collections.emptyList();
    }

    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        ProblemList<Problem> problems = new ProblemList<Problem>();
        if (this.cmdLineArgs != null) {
            for (String s : this.cmdLineArgs) {
                try {
                    KVP kvp = KVP.splitKVP(s, KVP_DELIMITER);
                    this.attemptToAdd(appConfigDef, values, problems, kvp.getName(), kvp.getValue());
                }
                catch (ParsingException e) {
                    problems.add(new LoaderProblem.ParsingLoaderProblem(this, null, null, e));
                }
            }
            values.trimToSize();
        }
        return new LoaderValues(this, values, problems);
    }

    @Override
    public String getSpecificLoadDescription() {
        return "string arguments from the command line at startup";
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return true;
    }

    @Override
    public boolean isUnrecognizedPropertyNamesConsideredAProblem() {
        return true;
    }

    @Override
    public String getLoaderType() {
        return "KeyValuePair";
    }

    @Override
    public String getLoaderDialect() {
        return "FromSingleString";
    }
}

