/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;

public class PropertyValue {
    private final Property<?> property;
    private final Object value;
    private final ProblemList<Problem> problems;

    public boolean equals(Object obj) {
        boolean basicPropsEq = false;
        if (obj instanceof PropertyValue) {
            PropertyValue other = (PropertyValue)obj;
            if (this.property == other.property) {
                if (this.value != null && other.value != null) {
                    basicPropsEq = this.value.equals(other.value);
                } else if (this.value == null && other.value == null) {
                    basicPropsEq = true;
                }
            }
            if (basicPropsEq) {
                return !this.hasProblems() && !other.hasProblems();
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        if (this.property != null) {
            hash *= this.property.hashCode();
        }
        if (this.value != null) {
            hash *= this.value.hashCode();
        }
        for (Problem p : this.problems) {
            hash *= p.hashCode();
        }
        return hash;
    }

    public PropertyValue(Property<?> prop, Object value) {
        this.property = prop;
        this.value = value;
        this.problems = ProblemList.EMPTY_PROBLEM_LIST;
    }

    public PropertyValue(Property<?> prop, Object value, ProblemList<Problem> inIssues) {
        this.property = prop;
        this.value = value;
        this.problems = inIssues != null && inIssues.size() > 0 ? new ProblemList.UnmodifiableProblemList<Problem>(inIssues) : ProblemList.EMPTY_PROBLEM_LIST;
    }

    public Property<?> getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasProblems() {
        return this.problems.size() > 0;
    }

    public ProblemList<Problem> getProblems() {
        return this.problems;
    }
}

