/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.util.AndHowUtil;

public class PropertyCoord {
    Property<?> property;
    Class<? extends BasePropertyGroup> group;
    String name;

    public PropertyCoord(Class<? extends BasePropertyGroup> group, Property<?> prop) {
        this.property = prop;
        this.group = group;
        if (group != null && this.property != null) {
            try {
                this.name = AndHowUtil.getCanonicalName(group, this.property);
            }
            catch (Exception ex) {
                this.name = "[[Security exception while trying to determine the property canonical name]]";
            }
            if (this.name == null) {
                this.name = "[[Unable to determine the property canonical name]]";
            }
        } else {
            this.name = "[[Unknown]]";
        }
    }

    public Property<?> getProperty() {
        return this.property;
    }

    public Class<? extends BasePropertyGroup> getGroup() {
        return this.group;
    }

    public String getGroupName() {
        if (this.group != null) {
            return this.group.getCanonicalName();
        }
        return "[[Unknown]]";
    }

    public String getPropName() {
        return this.name;
    }
}

