/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.property;

import java.util.List;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.PropertyType;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueType;
import org.yarnandtail.andhow.property.PropertyBase;
import org.yarnandtail.andhow.property.PropertyBuilderBase;
import org.yarnandtail.andhow.property.QuotedSpacePreservingTrimmer;
import org.yarnandtail.andhow.valid.StringValidator;
import org.yarnandtail.andhow.valuetype.StrType;

public class StrProp
extends PropertyBase<String> {
    public StrProp(String defaultValue, boolean required, String shortDesc, List<Validator<String>> validators, List<Name> aliases, PropertyType paramType, ValueType<String> valueType, Trimmer trimmer, String helpText) {
        super(defaultValue, required, shortDesc, validators, aliases, paramType, valueType, trimmer, helpText);
    }

    public static StrBuilder builder() {
        return new StrBuilder();
    }

    public static class StrBuilder
    extends PropertyBuilderBase<StrBuilder, StrProp, String> {
        public StrBuilder() {
            this.instance = this;
            this.valueType(StrType.instance());
            this.trimmer(QuotedSpacePreservingTrimmer.instance());
        }

        @Override
        public StrProp build() {
            return new StrProp((String)this._defaultValue, this._required, this._shortDesc, this._validators, (List<Name>)this._aliases, PropertyType.SINGLE_NAME_VALUE, this._valueType, this._trimmer, this._helpText);
        }

        public StrBuilder mustMatchRegex(String regex) {
            this.validation(new StringValidator.Regex(regex));
            return this;
        }

        public StrBuilder mustStartWith(String prefix) {
            this.validation(new StringValidator.StartsWith(prefix, false));
            return this;
        }

        public StrBuilder mustStartWithIgnoreCase(String prefix) {
            this.validation(new StringValidator.StartsWith(prefix, true));
            return this;
        }

        public StrBuilder mustEndWith(String sufix) {
            this.validation(new StringValidator.EndsWith(sufix, false));
            return this;
        }

        public StrBuilder mustEndWithIgnoreCase(String sufix) {
            this.validation(new StringValidator.EndsWith(sufix, true));
            return this;
        }
    }
}

