/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.ExportGroup;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValueMap;
import org.yarnandtail.andhow.internal.AndHowCore;
import org.yarnandtail.andhow.load.StringArgumentLoader;

public class AndHow
implements ConstructionDefinition,
ValueMap {
    public static final String ANDHOW_INLINE_NAME = "AndHow";
    public static final String ANDHOW_NAME = "AndHow!";
    public static final String ANDHOW_URL = "https://github.com/eeverman/andhow";
    public static final String ANDHOW_TAG_LINE = "strong.simple.valid.AppConfiguration";
    private static AndHow singleInstance;
    private static final Object lock;
    AndHowCore core;
    Reloader reloader;

    private AndHow(NamingStrategy naming, List<Loader> loaders, List<Class<? extends BasePropertyGroup>> registeredGroups) throws AppFatalException {
        this.core = new AndHowCore(naming, loaders, registeredGroups);
        this.reloader = new Reloader(this);
    }

    public static AndHowBuilder builder() {
        return new AndHowBuilder();
    }

    public static AndHow instance() {
        if (singleInstance != null && AndHow.singleInstance.core != null) {
            return singleInstance;
        }
        throw new RuntimeException("AndHow has not been initialized.  Possible causes:  1) There is a race condition where Property access may happen before configuration 2) There is no configuration at the entry point to the application. Refer to https://github.com/eeverman/andhow for code examples and FAQs.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Reloader build(NamingStrategy naming, List<Loader> loaders, List<Class<? extends BasePropertyGroup>> registeredGroups) throws AppFatalException, RuntimeException {
        Object object = lock;
        synchronized (object) {
            if (singleInstance != null) {
                throw new RuntimeException("Already constructed!");
            }
            singleInstance = new AndHow(naming, loaders, registeredGroups);
            return AndHow.singleInstance.reloader;
        }
    }

    @Override
    public boolean isExplicitlySet(Property<?> prop) {
        return this.core.isExplicitlySet(prop);
    }

    @Override
    public <T> T getExplicitValue(Property<T> prop) {
        return this.core.getExplicitValue(prop);
    }

    @Override
    public <T> T getEffectiveValue(Property<T> prop) {
        return this.core.getEffectiveValue(prop);
    }

    @Override
    public List<EffectiveName> getAliases(Property<?> property) {
        return this.core.getAliases(property);
    }

    @Override
    public String getCanonicalName(Property<?> prop) {
        return this.core.getCanonicalName(prop);
    }

    @Override
    public Class<? extends BasePropertyGroup> getGroupForProperty(Property<?> prop) {
        return this.core.getGroupForProperty(prop);
    }

    @Override
    public List<Property<?>> getPropertiesForGroup(Class<? extends BasePropertyGroup> group) {
        return this.core.getPropertiesForGroup(group);
    }

    @Override
    public Property<?> getProperty(String name) {
        return this.core.getProperty(name);
    }

    @Override
    public List<Class<? extends BasePropertyGroup>> getPropertyGroups() {
        return this.core.getPropertyGroups();
    }

    @Override
    public List<Property<?>> getProperties() {
        return this.core.getProperties();
    }

    @Override
    public List<ExportGroup> getExportGroups() {
        return this.core.getExportGroups();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.core.getNamingStrategy();
    }

    @Override
    public Map<String, String> getSystemEnvironment() {
        return this.core.getSystemEnvironment();
    }

    static {
        lock = new Object();
    }

    public static class Reloader {
        private final AndHow instance;

        private Reloader(AndHow instance) {
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload(NamingStrategy naming, List<Loader> loaders, List<Class<? extends BasePropertyGroup>> registeredGroups) throws AppFatalException {
            Object object = lock;
            synchronized (object) {
                this.instance.core = new AndHowCore(naming, loaders, registeredGroups);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = lock;
            synchronized (object) {
                if (this.instance != null) {
                    this.instance.core = null;
                }
            }
        }
    }

    public static class AndHowBuilder {
        private final List<Loader> _loaders = new ArrayList<Loader>();
        private NamingStrategy _namingStrategy = null;
        private final List<String> _cmdLineArgs = new ArrayList<String>();
        List<Class<? extends BasePropertyGroup>> _groups = new ArrayList<Class<? extends BasePropertyGroup>>();
        private Integer addCmdLineLoaderAtPosition = null;

        public AndHowBuilder loader(Loader loader) {
            this._loaders.add(loader);
            return this;
        }

        public AndHowBuilder loaders(Collection<Loader> loaders) {
            this._loaders.addAll(loaders);
            return this;
        }

        public AndHowBuilder group(Class<? extends BasePropertyGroup> group) {
            this._groups.add(group);
            return this;
        }

        public AndHowBuilder groups(Collection<Class<? extends BasePropertyGroup>> groups) {
            this._groups.addAll(groups);
            return this;
        }

        public AndHowBuilder cmdLineArgs(String[] commandLineArgs) {
            this._cmdLineArgs.addAll(Arrays.asList(commandLineArgs));
            if (this.addCmdLineLoaderAtPosition == null) {
                this.addCmdLineLoaderAtPosition = this._loaders.size();
            }
            return this;
        }

        public AndHowBuilder cmdLineArg(String key, String value) {
            if (value != null) {
                this._cmdLineArgs.add(key + "=" + value);
            } else {
                this._cmdLineArgs.add(key);
            }
            if (this.addCmdLineLoaderAtPosition == null) {
                this.addCmdLineLoaderAtPosition = this._loaders.size();
            }
            return this;
        }

        public AndHowBuilder namingStrategy(NamingStrategy namingStrategy) {
            this._namingStrategy = namingStrategy;
            return this;
        }

        private void throwFatal(String message) {
            AppFatalException afe = new AppFatalException(message);
            StackTraceElement[] stes = afe.getStackTrace();
            stes = Arrays.copyOfRange(stes, 2, stes.length);
            afe.setStackTrace(stes);
            throw afe;
        }

        public void build() throws AppFatalException {
            if (this.addCmdLineLoaderAtPosition != null) {
                this._loaders.add(this.addCmdLineLoaderAtPosition, new StringArgumentLoader(this._cmdLineArgs));
            }
            AndHow.build(this._namingStrategy, this._loaders, this._groups);
        }

        public Reloader buildForNonPropduction() throws AppFatalException {
            if (this.addCmdLineLoaderAtPosition != null) {
                this._loaders.add(this.addCmdLineLoaderAtPosition, new StringArgumentLoader(this._cmdLineArgs));
            }
            return AndHow.build(this._namingStrategy, this._loaders, this._groups);
        }

        public void reloadForNonPropduction(Reloader reloader) throws AppFatalException {
            if (this.addCmdLineLoaderAtPosition != null) {
                this._loaders.add(this.addCmdLineLoaderAtPosition, new StringArgumentLoader(this._cmdLineArgs));
            }
            reloader.reload(this._namingStrategy, this._loaders, this._groups);
        }
    }
}

