/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.ValueMap;

public class LoaderValues
implements ValueMap {
    public static final List<PropertyValue> EMPTY_PROP_VALUE_LIST = Collections.emptyList();
    private final Loader loader;
    private final List<PropertyValue> values;
    private final ProblemList<Problem> problems;

    public LoaderValues(Loader loader, Problem problem) {
        ProblemList<Problem> probs = new ProblemList<Problem>();
        probs.add(problem);
        this.problems = new ProblemList.UnmodifiableProblemList<Problem>(probs);
        this.loader = loader;
        this.values = EMPTY_PROP_VALUE_LIST;
    }

    public LoaderValues(Loader loader) {
        this.problems = new ProblemList.UnmodifiableProblemList<Problem>();
        this.loader = loader;
        this.values = EMPTY_PROP_VALUE_LIST;
    }

    public LoaderValues(Loader loader, List<PropertyValue> inValues, ProblemList<Problem> problems) {
        ProblemList myProblems = new ProblemList();
        myProblems.addAll(problems);
        if (loader == null) {
            throw new RuntimeException("The loader cannot be null");
        }
        this.loader = loader;
        if (inValues != null && inValues.size() > 0) {
            ArrayList<PropertyValue> newValues = new ArrayList<PropertyValue>();
            newValues.addAll(inValues);
            newValues.trimToSize();
            this.values = Collections.unmodifiableList(newValues);
            for (PropertyValue pv : this.values) {
                myProblems.addAll(pv.getProblems());
            }
        } else {
            this.values = EMPTY_PROP_VALUE_LIST;
        }
        this.problems = new ProblemList.UnmodifiableProblemList<Problem>(myProblems);
    }

    public Loader getLoader() {
        return this.loader;
    }

    public List<PropertyValue> getValues() {
        return this.values;
    }

    @Override
    public <T> T getExplicitValue(Property<T> prop) {
        if (prop == null) {
            return null;
        }
        return prop.getValueType().cast(this.values.stream().filter(pv -> prop.equals(pv.getProperty())).findFirst().map(pv -> pv.getValue()).orElse(null));
    }

    @Override
    public <T> T getEffectiveValue(Property<T> prop) {
        if (prop == null) {
            return null;
        }
        if (this.isExplicitlySet(prop)) {
            return this.getExplicitValue(prop);
        }
        return prop.getDefaultValue();
    }

    @Override
    public boolean isExplicitlySet(Property<?> prop) {
        return this.values.stream().anyMatch(p -> p.getProperty().equals(prop));
    }

    public ProblemList<Problem> getProblems() {
        return this.problems;
    }
}

