/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.internal.ConstructionProblem;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.internal.RequirementProblem;
import org.yarnandtail.andhow.internal.ValueProblem;
import org.yarnandtail.andhow.util.TextUtil;

public class ReportGenerator {
    public static final int DEFAULT_LINE_WIDTH = 90;

    public static void printProblems(PrintStream out, AppFatalException fatalException, ConstructionDefinition appDef) {
        try {
            ReportGenerator.printProblemHR(out);
            out.println(TextUtil.padRight("== Problem report from AndHow!  strong.simple.valid.AppConfiguration  ", "=", 90));
            out.println(TextUtil.padRight(TextUtil.repeat("=", 50) + "  " + "https://github.com/eeverman/andhow" + " ", "=", 90));
            ReportGenerator.printConstructionProblems(out, fatalException.getProblems().filter(ConstructionProblem.class), appDef);
            ReportGenerator.printLoaderProblems(out, fatalException.getProblems().filter(LoaderProblem.class), appDef);
            ReportGenerator.printValueProblems(out, fatalException.getProblems().filter(ValueProblem.class), appDef);
            ReportGenerator.printRequirementProblems(out, fatalException.getProblems().filter(RequirementProblem.class), appDef);
            ReportGenerator.printProblemHR(out);
        }
        catch (Exception e) {
            out.println("Uh oh.  There was an Exception while printing the list of problems with the app config.");
            out.println("Error Type: " + e.getClass().getCanonicalName() + ",  Error message: " + e.getMessage());
            e.printStackTrace(out);
        }
    }

    public static void printConstructionProblems(PrintStream out, List<ConstructionProblem> probs, ConstructionDefinition appDef) {
        if (!probs.isEmpty()) {
            out.println("CONSTRUCTION PROBLEMS  - Basic problems configuring and starting up the AndHow frameowork.");
            out.println("AndHow may have been built in an inconsistent way, such as a default value that violates its own validation rules.");
            out.println("When there are construction problems, no attempt is made to load configuration values.");
            out.println();
            out.println("Detailed list of Construction Problems:");
            for (ConstructionProblem p : probs) {
                TextUtil.println(out, 90, "", p.getFullMessage());
            }
        }
    }

    public static void printLoaderProblems(PrintStream out, List<LoaderProblem> probs, ConstructionDefinition appDef) {
        if (!probs.isEmpty()) {
            TextUtil.println(out, 90, "", "LOADER PROBLEMS - Issues that prevent a Loader from loading a value to a Property.");
            out.println();
            out.println("Detailed list of Loader Problems:");
            for (LoaderProblem p : probs) {
                TextUtil.println(out, 90, "", p.getFullMessage());
            }
        }
    }

    public static void printValueProblems(PrintStream out, List<ValueProblem> probs, ConstructionDefinition appDef) {
        if (!probs.isEmpty()) {
            TextUtil.println(out, 90, "", "VALUE PROBLEMS - Values that violate validation rules.");
            out.println();
            out.println("Detailed list of Value Problems:");
            for (ValueProblem p : probs) {
                TextUtil.println(out, 90, "", p.getFullMessage());
            }
        }
    }

    public static void printRequirementProblems(PrintStream out, List<RequirementProblem> probs, ConstructionDefinition appDef) {
        if (!probs.isEmpty()) {
            out.println("REQUIRMENT PROBLEMS - When a required property is not provided");
            out.println("Note:  Issues, above, preventing values from loading may also result in requirements problems.");
            out.println();
            out.println("Detailed list of Requirements Problems:");
            for (RequirementProblem p : probs) {
                TextUtil.println(out, 90, "", p.getFullMessage());
            }
        }
    }

    public static void printProblemHR(PrintStream out) {
        out.println(TextUtil.repeat("=", 90));
    }

    public static void printConfigSamples(ConstructionDefinition appDef, PrintStream out, List<Loader> loaders, boolean isDueToErrors) {
        out.println();
        if (isDueToErrors) {
            out.println("== Since there were startup errors, sample configuration will be printed for each Loader that supports it ==");
        } else {
            out.println("== As requested, sample configuration will be printed for each Loader that supports it ==");
        }
        out.println();
        HashSet<String> printedLoaderTypes = new HashSet<String>();
        int supportedLoaders = 0;
        for (Loader loader : loaders) {
            String fullType;
            SamplePrinter printer = loader.getConfigSamplePrinter();
            if (printer == null || printedLoaderTypes.contains(fullType = TextUtil.trimToEmpty(loader.getLoaderType()) + "---" + TextUtil.trimToEmpty(loader.getLoaderDialect()))) continue;
            printedLoaderTypes.add(fullType);
            ++supportedLoaders;
            printer.printSampleStart(appDef, out);
            for (Class<? extends BasePropertyGroup> group : appDef.getPropertyGroups()) {
                printer.printPropertyGroupStart(appDef, out, group);
                try {
                    for (Property<?> prop : appDef.getPropertiesForGroup(group)) {
                        printer.printProperty(appDef, out, group, prop);
                    }
                }
                catch (Exception ex) {
                    TextUtil.println(out, 90, "", "SECURITY EXCEPTION TRYING TO ACCESS THIS GROUP. ENSURE ALL Property FIELDS ARE PUBLIC IN THE PropertyGroup AND THAT THERE IS NOT A SECURITY MANAGER BLOCKING ACCESS TO REFLECTION.");
                }
                printer.printPropertyGroupEnd(appDef, out, group);
            }
            printer.printSampleEnd(appDef, out);
        }
        if (supportedLoaders == 0) {
            out.println();
            out.println("== None of the configured Loaders support creating configuration samples ==");
            out.println();
        }
    }
}

