/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.PropertyCoord;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class RequirementProblem
implements Problem {
    protected PropertyCoord propertyCoord;

    public PropertyCoord getPropertyCoord() {
        return this.propertyCoord;
    }

    @Override
    public String getFullMessage() {
        return this.getProblemContext() + ": " + this.getProblemDescription();
    }

    public static class RequiredPropertyGroupProblem
    extends RequirementProblem {
        public RequiredPropertyGroupProblem(Class<? extends BasePropertyGroup> group) {
            this.propertyCoord = new PropertyCoord(group, null);
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("PropertyGroup {}", this.propertyCoord.getGroup().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return "This PropertyGroup is required - A value for at least one its propertides must be found by one of the loaders";
        }
    }

    public static class RequiredPropertyProblem
    extends RequirementProblem {
        public RequiredPropertyProblem(Class<? extends BasePropertyGroup> group, Property<?> prop) {
            this.propertyCoord = new PropertyCoord(group, prop);
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("Property {}", this.propertyCoord.getPropName());
        }

        @Override
        public String getProblemDescription() {
            return "This Property is required - value must be found by one of the loaders";
        }
    }
}

