/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.load.BaseLoader;

public class EnviromentVariableLoader
extends BaseLoader {
    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        ProblemList<Problem> problems = new ProblemList<Problem>();
        Map<String, String> props = appConfigDef.getSystemEnvironment();
        Set<String> keys = props.keySet();
        for (String key : keys) {
            if (key == null) continue;
            String val = props.get(key);
            this.attemptToAdd(appConfigDef, values, problems, key, val);
        }
        values.trimToSize();
        return new LoaderValues(this, values, problems);
    }

    @Override
    public String getSpecificLoadDescription() {
        return "java.lang.System.getenv()";
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public boolean isUnrecognizedPropertyNamesConsideredAProblem() {
        return false;
    }

    @Override
    public String getLoaderType() {
        return "EnvironmentVariable";
    }

    @Override
    public String getLoaderDialect() {
        return null;
    }
}

