/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.load.LoaderException;
import org.yarnandtail.andhow.load.PropertyFileBaseLoader;
import org.yarnandtail.andhow.property.StrProp;

public class PropertyFileOnClasspathLoader
extends PropertyFileBaseLoader {
    StrProp classpath;
    String specificLoadDescription = null;

    public PropertyFileOnClasspathLoader(StrProp classpathOfPropertyFile) {
        this.classpath = classpathOfPropertyFile;
    }

    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        String path = existingValues.getEffectiveValue(this.classpath);
        this.specificLoadDescription = "file on classpath at: " + path;
        if (path != null) {
            LoaderValues vals = this.load(appConfigDef, existingValues, path);
            return vals;
        }
        return new LoaderValues(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues, String path) {
        try (InputStream inS = PropertyFileOnClasspathLoader.class.getResourceAsStream(path);){
            if (inS == null) {
                LoaderValues loaderValues2 = new LoaderValues(this, new LoaderProblem.SourceNotFoundLoaderProblem(this, "Expected file at classpath:" + path));
                return loaderValues2;
            }
            LoaderValues loaderValues = this.loadInputStreamToProps(inS, path, appConfigDef, existingValues);
            return loaderValues;
        }
        catch (LoaderException e) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, e.getCause(), "classpath:" + path));
        }
        catch (IOException ioe) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, ioe, "classpath:" + path));
        }
    }

    @Override
    public List<Property> getInstanceConfig() {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.classpath);
        return list;
    }

    @Override
    public String getSpecificLoadDescription() {
        if (this.specificLoadDescription != null) {
            return this.specificLoadDescription;
        }
        return "file on classpath at: " + (String)this.classpath.getValue();
    }
}

