/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.load.LoaderException;
import org.yarnandtail.andhow.load.PropertyFileBaseLoader;
import org.yarnandtail.andhow.property.StrProp;
import org.yarnandtail.andhow.util.TextUtil;

public class PropertyFileOnFilesystemLoader
extends PropertyFileBaseLoader {
    StrProp filepath;
    String specificLoadDescription = null;

    public PropertyFileOnFilesystemLoader(StrProp filePathOfPropertyFile) {
        this.filepath = filePathOfPropertyFile;
    }

    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        String path = existingValues.getEffectiveValue(this.filepath);
        this.specificLoadDescription = TextUtil.format("file on the file system at path : {} ({})", path, this.getAbsPath(path));
        if (path != null) {
            LoaderValues vals = this.load(appConfigDef, existingValues, path);
            return vals;
        }
        return new LoaderValues(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues, String path) {
        try {
            File propFile = new File(path);
            try (FileInputStream inS = new FileInputStream(propFile);){
                LoaderValues loaderValues = this.loadInputStreamToProps(inS, path, appConfigDef, existingValues);
                return loaderValues;
            }
            catch (FileNotFoundException e) {
                return new LoaderValues(this, new LoaderProblem.SourceNotFoundLoaderProblem(this, "Expected file on filesystem:" + path));
            }
        }
        catch (LoaderException e) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, e.getCause(), "filesystem:" + path));
        }
        catch (IOException ioe) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, ioe, "filesystem:" + path));
        }
    }

    @Override
    public List<Property> getInstanceConfig() {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.filepath);
        return list;
    }

    @Override
    public String getSpecificLoadDescription() {
        if (this.specificLoadDescription != null) {
            return this.specificLoadDescription;
        }
        return TextUtil.format("file on the file system at path : {} ({})", this.filepath.getValue(), this.getAbsPath((String)this.filepath.getValue()));
    }

    private String getAbsPath(String anything) {
        try {
            File f = new File(anything);
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            return "[Unknown absolute path]";
        }
    }
}

