/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.load.BaseLoader;

public class SystemPropertyLoader
extends BaseLoader {
    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        ProblemList<Problem> problems = new ProblemList<Problem>();
        Properties props = System.getProperties();
        Set<Object> keys = props.keySet();
        for (Object key : keys) {
            if (key == null) continue;
            String k = key.toString();
            String v = props.getProperty(k);
            this.attemptToAdd(appConfigDef, values, problems, k, v);
        }
        values.trimToSize();
        return new LoaderValues(this, values, problems);
    }

    @Override
    public String getSpecificLoadDescription() {
        return "java.lang.System.getProperties()";
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public boolean isUnrecognizedPropertyNamesConsideredAProblem() {
        return false;
    }

    @Override
    public String getLoaderType() {
        return "SystemProperty";
    }

    @Override
    public String getLoaderDialect() {
        return null;
    }
}

