/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.property;

import java.util.List;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.PropertyType;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueType;
import org.yarnandtail.andhow.property.PropertyBase;
import org.yarnandtail.andhow.property.PropertyBuilderBase;
import org.yarnandtail.andhow.property.TrimToNullTrimmer;
import org.yarnandtail.andhow.valid.IntValidator;
import org.yarnandtail.andhow.valuetype.IntType;

public class IntProp
extends PropertyBase<Integer> {
    public IntProp(Integer defaultValue, boolean required, String shortDesc, List<Validator<Integer>> validators, List<Name> aliases, PropertyType paramType, ValueType<Integer> valueType, Trimmer trimmer, String helpText) {
        super(defaultValue, required, shortDesc, validators, aliases, paramType, valueType, trimmer, helpText);
    }

    public static IntBuilder builder() {
        return new IntBuilder();
    }

    public static class IntBuilder
    extends PropertyBuilderBase<IntBuilder, IntProp, Integer> {
        public IntBuilder() {
            this.instance = this;
            this.valueType(IntType.instance());
            this.trimmer(TrimToNullTrimmer.instance());
        }

        @Override
        public IntProp build() {
            return new IntProp((Integer)this._defaultValue, this._required, this._shortDesc, this._validators, (List<Name>)this._aliases, PropertyType.SINGLE_NAME_VALUE, this._valueType, this._trimmer, this._helpText);
        }

        public IntBuilder mustBeGreaterThan(int reference) {
            this.validation(new IntValidator.GreaterThan(reference));
            return (IntBuilder)this.instance;
        }

        public IntBuilder mustBeGreaterThanOrEqualTo(int reference) {
            this.validation(new IntValidator.GreaterThanOrEqualTo(reference));
            return (IntBuilder)this.instance;
        }

        public IntBuilder mustBeLessThan(int reference) {
            this.validation(new IntValidator.LessThan(reference));
            return (IntBuilder)this.instance;
        }

        public IntBuilder mustBeLessThanOrEqualTo(int reference) {
            this.validation(new IntValidator.LessThanOrEqualTo(reference));
            return (IntBuilder)this.instance;
        }
    }
}

