/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.sample.BaseSamplePrinter;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.sample.TextBlock;
import org.yarnandtail.andhow.util.AndHowUtil;
import org.yarnandtail.andhow.util.TextUtil;

public class JndiLoaderSamplePrinter
extends BaseSamplePrinter
implements SamplePrinter {
    protected PrintFormat format = new PrintFormat();

    public JndiLoaderSamplePrinter() {
        this.format.blockCommentStart = "<!--";
        this.format.blockCommentEnd = "-->";
        this.format.blockCommentSeparator = " ";
        this.format.lineCommentPrefix = null;
        this.format.lineCommentPrefixSeparator = " ";
        this.format.secondLineIndent = "\t";
        this.format.hr = TextUtil.repeat("- ", 45);
        this.format.lineWidth = 90;
    }

    @Override
    public PrintFormat getFormat() {
        return this.format;
    }

    @Override
    public TextBlock getSampleFileStart() {
        TextBlock tb = new TextBlock(false, false);
        tb.addLine("<Context>");
        return tb;
    }

    @Override
    public TextBlock getSampleStartComment(ConstructionDefinition definition) {
        TextBlock tb = new TextBlock(true, true);
        tb.addHR();
        tb.addLine("Sample JNDI config file generated by AndHow!");
        tb.addLine("strong.simple.valid.AppConfiguration  -  https://github.com/eeverman/andhow");
        tb.addLine("This sample uses Tomcat syntax. JNDI configuration for other servers will be similar.");
        tb.addHR();
        return tb;
    }

    @Override
    public String getInAliaseString(ConstructionDefinition definition, EffectiveName name) {
        return definition.getNamingStrategy().getUriName(name.getActualName());
    }

    @Override
    public TextBlock getActualProperty(ConstructionDefinition definition, Class<? extends BasePropertyGroup> group, Property prop) throws Exception {
        TextBlock tb = new TextBlock(false, false);
        String propCanonName = definition.getNamingStrategy().getUriName(AndHowUtil.getCanonicalName(group, prop));
        String type = prop.getValueType().getDestinationType().getCanonicalName();
        if (prop.getDefaultValue() != null) {
            tb.addLine(TextUtil.format("<Environment name=\"{}\" value=\"{}\" type=\"{}\" override=\"false\"/>", propCanonName, TextUtil.escapeXml(prop.getDefaultValue().toString()), type));
        } else {
            tb.addLine(TextUtil.format("<Environment name=\"{}\" value=\"[{}]\" type=\"{}\" override=\"false\"/>", propCanonName, prop.getValueType().getDestinationType().getSimpleName(), type));
        }
        return tb;
    }

    @Override
    public TextBlock getSampleFileEnd() {
        TextBlock tb = new TextBlock(false, false);
        tb.addLine("</Context>");
        return tb;
    }
}

