/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.GroupExport;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ExportGroup;
import org.yarnandtail.andhow.api.Exporter;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.ConstructionDefinitionMutable;
import org.yarnandtail.andhow.internal.ConstructionProblem;
import org.yarnandtail.andhow.internal.NameAndProperty;

public class AndHowUtil {
    public static ConstructionDefinitionMutable buildDefinition(List<Class<? extends BasePropertyGroup>> groups, List<Loader> loaders, NamingStrategy naming, ProblemList<Problem> problems) {
        ConstructionDefinitionMutable appDef = new ConstructionDefinitionMutable(naming);
        if (groups != null) {
            for (Class clazz : groups) {
                problems.addAll(AndHowUtil.registerGroup(appDef, clazz));
                try {
                    List<Exporter> exps = AndHowUtil.getExporters(clazz);
                    for (Exporter e : exps) {
                        ExportGroup eg = new ExportGroup(e, clazz);
                        appDef.addExportGroup(eg);
                    }
                }
                catch (InstantiationException ex) {
                    ConstructionProblem.ExportException ee = new ConstructionProblem.ExportException(ex, clazz, "Unable to created a new instance of one of the Exporters for this group.  Do they all have zero argument constructors?");
                    problems.add(ee);
                }
                catch (IllegalAccessException ex) {
                    ConstructionProblem.SecurityException se = new ConstructionProblem.SecurityException(ex, clazz);
                    problems.add(se);
                }
            }
        }
        if (loaders != null) {
            for (Loader loader : loaders) {
                if (loader.getClassConfig() != null) {
                    problems.addAll(AndHowUtil.registerGroup(appDef, loader.getClassConfig()));
                }
                for (Property p : loader.getInstanceConfig()) {
                    if (p == null) {
                        problems.add(new ConstructionProblem.LoaderPropertyIsNull(loader));
                        continue;
                    }
                    if (appDef.getCanonicalName(p) != null) continue;
                    problems.add(new ConstructionProblem.LoaderPropertyNotRegistered(loader, p));
                }
            }
        }
        return appDef;
    }

    protected static ProblemList<ConstructionProblem> registerGroup(ConstructionDefinitionMutable appDef, Class<? extends BasePropertyGroup> group) {
        ProblemList<ConstructionProblem> problems = new ProblemList<ConstructionProblem>();
        try {
            List<NameAndProperty> nameAndProperties = AndHowUtil.getProperties(group);
            for (NameAndProperty nameAndProp : nameAndProperties) {
                problems.add(appDef.addProperty(group, nameAndProp.property));
            }
        }
        catch (Exception ex) {
            ConstructionProblem.SecurityException se = new ConstructionProblem.SecurityException(ex, group);
            problems.add(se);
        }
        return problems;
    }

    public static void printExceptions(List<? extends Exception> exceptions, PrintStream out) {
        for (Exception exception : exceptions) {
            out.println(exception.getMessage());
        }
    }

    public static AppFatalException buildFatalException(ProblemList<Problem> problems) {
        return new AppFatalException("Unable to complete application configuration due to problems. See the System.err out or the log files for complete details.", problems);
    }

    public static List<Exporter> getExporters(Class<? extends BasePropertyGroup> group) throws InstantiationException, IllegalAccessException {
        GroupExport[] groupExports;
        ArrayList<Exporter> exps = new ArrayList<Exporter>();
        for (GroupExport ge : groupExports = (GroupExport[])group.getAnnotationsByType(GroupExport.class)) {
            Class<? extends Exporter> expClass = ge.exporter();
            Exporter exporter = expClass.newInstance();
            exporter.setExportByCanonicalName(ge.exportByCanonicalName());
            exporter.setExportByOutAliases(ge.exportByOutAliases());
            exps.add(exporter);
        }
        exps.trimToSize();
        return Collections.unmodifiableList(exps);
    }

    public static List<NameAndProperty> getProperties(Class<? extends BasePropertyGroup> group) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        Field[] fields;
        ArrayList<NameAndProperty> props = new ArrayList<NameAndProperty>();
        for (Field f : fields = group.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Property.class.isAssignableFrom(f.getType())) continue;
            Property cp = null;
            try {
                cp = (Property)f.get(null);
            }
            catch (Exception ex) {
                f.setAccessible(true);
                cp = (Property)f.get(null);
            }
            props.add(new NameAndProperty(f.getName(), cp));
        }
        return props;
    }

    public static String getFieldName(Class<? extends BasePropertyGroup> group, Property<?> property) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        Field[] fields;
        for (Field f : fields = group.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Property.class.isAssignableFrom(f.getType())) continue;
            Property cp = null;
            try {
                cp = (Property)f.get(null);
            }
            catch (Exception ex) {
                f.setAccessible(true);
                cp = (Property)f.get(null);
            }
            if (!cp.equals(property)) continue;
            return f.getName();
        }
        return null;
    }

    public static String getCanonicalName(Class<? extends BasePropertyGroup> group, Property<?> property) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        String fieldName = AndHowUtil.getFieldName(group, property);
        if (fieldName != null) {
            return group.getCanonicalName() + "." + fieldName;
        }
        return null;
    }
}

