/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.valid;

import java.time.LocalDateTime;
import org.yarnandtail.andhow.api.Validator;

public abstract class LocalDateTimeValidator
implements Validator<LocalDateTime> {
    protected LocalDateTime ref;

    @Override
    public boolean isSpecificationValid() {
        return this.ref != null;
    }

    @Override
    public String getInvalidSpecificationMessage() {
        return "The reference LocalDateTime cannot be null";
    }

    public static class SameTimeOrAfter
    extends LocalDateTimeValidator {
        public SameTimeOrAfter(LocalDateTime ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(LocalDateTime value) {
            if (value != null) {
                return value.isAfter(this.ref) || value.isEqual(this.ref);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be the same date and time or after " + this.ref.toString();
        }
    }

    public static class After
    extends LocalDateTimeValidator {
        public After(LocalDateTime ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(LocalDateTime value) {
            if (value != null) {
                return value.isAfter(this.ref);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be after " + this.ref.toString();
        }
    }

    public static class SameTimeOrBefore
    extends LocalDateTimeValidator {
        public SameTimeOrBefore(LocalDateTime ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(LocalDateTime value) {
            if (value != null) {
                return value.isBefore(this.ref) || value.isEqual(this.ref);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be the same date and time or before " + this.ref.toString();
        }
    }

    public static class Before
    extends LocalDateTimeValidator {
        public Before(LocalDateTime ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(LocalDateTime value) {
            if (value != null) {
                return value.isBefore(this.ref);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be before " + this.ref.toString();
        }
    }
}

