/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.valid;

import org.yarnandtail.andhow.api.Validator;

public class StringValidator {

    public static class Regex
    implements Validator<String> {
        String regex;

        public Regex(String regex) {
            this.regex = regex;
        }

        @Override
        public boolean isSpecificationValid() {
            try {
                "".matches(this.regex);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The expression '" + this.regex + "' is not a valid regex expression";
        }

        @Override
        public boolean isValid(String value) {
            return value != null && value.matches(this.regex);
        }

        @Override
        public String getTheValueMustDescription() {
            return "match the regex expression '" + this.regex + "'";
        }
    }

    public static class EndsWith
    implements Validator<String> {
        String sufix;
        boolean ignoreCase;

        public EndsWith(String sufix, boolean ignoreCase) {
            this.sufix = sufix;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean isSpecificationValid() {
            return this.sufix != null;
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The EndWith expression cannot be null";
        }

        @Override
        public boolean isValid(String value) {
            if (value != null) {
                if (this.ignoreCase) {
                    return value.toUpperCase().endsWith(this.sufix.toUpperCase());
                }
                return value.endsWith(this.sufix);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "end with '" + this.sufix + "'";
        }
    }

    public static class StartsWith
    implements Validator<String> {
        String prefix;
        boolean ignoreCase;

        public StartsWith(String prefix, boolean ignoreCase) {
            this.prefix = prefix;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean isSpecificationValid() {
            return this.prefix != null;
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The StartWith expression cannot be null";
        }

        @Override
        public boolean isValid(String value) {
            if (value != null) {
                if (this.ignoreCase) {
                    return value.toUpperCase().startsWith(this.prefix.toUpperCase());
                }
                return value.startsWith(this.prefix);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "start with '" + this.prefix + "'";
        }
    }
}

