/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValueMap;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.ValueMapWithContextBase;

public class ValueMapWithContextImmutable
extends ValueMapWithContextBase {
    private final ArrayList<LoaderValues> structuredValues = new ArrayList();
    private final ValueMap effectiveValues;
    private final boolean problem;

    public ValueMapWithContextImmutable(List<LoaderValues> inLoadedValuesList) {
        this.structuredValues.addAll(inLoadedValuesList);
        this.structuredValues.trimToSize();
        this.effectiveValues = super.buildValueMapImmutable(this.structuredValues);
        boolean willHaveProblem = false;
        for (LoaderValues lvs : this.structuredValues) {
            if (lvs.getProblems().size() <= 0) continue;
            willHaveProblem = true;
            break;
        }
        this.problem = willHaveProblem;
    }

    @Override
    public <T> T getExplicitValue(Property<T> prop) {
        return this.effectiveValues.getExplicitValue(prop);
    }

    @Override
    public <T> T getEffectiveValue(Property<T> prop) {
        return this.effectiveValues.getEffectiveValue(prop);
    }

    @Override
    public boolean isExplicitlySet(Property<?> prop) {
        return this.effectiveValues.isExplicitlySet(prop);
    }

    @Override
    public List<LoaderValues> getAllLoaderValues() {
        return Collections.unmodifiableList(this.structuredValues);
    }

    @Override
    public LoaderValues getAllValuesLoadedByLoader(Loader loader) {
        return this.getAllValuesLoadedByLoader(this.structuredValues, loader);
    }

    @Override
    public LoaderValues getEffectiveValuesLoadedByLoader(Loader loader) {
        return this.getEffectiveValuesLoadedByLoader(this.structuredValues, loader);
    }

    @Override
    public ValueMap getValueMapImmutable() {
        return this.effectiveValues;
    }

    @Override
    public ValueMapWithContext getValueMapWithContextImmutable() {
        return this;
    }

    @Override
    public boolean hasProblems() {
        return this.problem;
    }
}

