/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.internal.ValueProblem;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class BaseLoader
implements Loader {
    @Override
    public Class<? extends BasePropertyGroup> getClassConfig() {
        return null;
    }

    @Override
    public List<Property> getInstanceConfig() {
        return Collections.emptyList();
    }

    @Override
    public SamplePrinter getConfigSamplePrinter() {
        return null;
    }

    protected void attemptToAdd(ConstructionDefinition appConfigDef, List<PropertyValue> values, ProblemList<Problem> loaderProblems, String key, String strValue) {
        if ((key = TextUtil.trimToNull(key)) != null) {
            String effKey = appConfigDef.getNamingStrategy().toEffectiveName(key);
            Property<?> prop = appConfigDef.getProperty(effKey);
            if (prop != null) {
                PropertyValue pv = null;
                try {
                    pv = this.createValue(appConfigDef, prop, strValue);
                }
                catch (ParsingException e) {
                    loaderProblems.add(new LoaderProblem.StringConversionLoaderProblem(this, appConfigDef.getGroupForProperty(prop), prop, e.getProblemText()));
                }
                if (pv != null) {
                    PropertyValue dup = this.findDuplicateProperty(pv, values);
                    if (dup == null) {
                        values.add(pv);
                    } else {
                        loaderProblems.add(new LoaderProblem.DuplicatePropertyLoaderProblem(this, appConfigDef.getGroupForProperty(prop), prop));
                    }
                }
            } else if (this.isUnrecognizedPropertyNamesConsideredAProblem()) {
                loaderProblems.add(new LoaderProblem.UnknownPropertyLoaderProblem(this, key));
            }
        }
    }

    protected void attemptToAdd(ConstructionDefinition appConfigDef, List<PropertyValue> values, ProblemList<Problem> loaderProblems, Property prop, Object value) {
        if (prop != null) {
            PropertyValue pv = null;
            if (value.getClass().equals(prop.getValueType().getDestinationType())) {
                pv = new PropertyValue(prop, value);
            } else if (value instanceof String) {
                try {
                    pv = this.createValue(appConfigDef, prop, value.toString());
                }
                catch (ParsingException e) {
                    loaderProblems.add(new LoaderProblem.StringConversionLoaderProblem(this, appConfigDef.getGroupForProperty(prop), prop, e.getProblemText()));
                }
            } else {
                loaderProblems.add(new LoaderProblem.ObjectConversionValueProblem(this, appConfigDef.getGroupForProperty(prop), prop, value));
            }
            if (pv != null) {
                PropertyValue dup = this.findDuplicateProperty(pv, values);
                if (dup == null) {
                    values.add(pv);
                } else {
                    loaderProblems.add(new LoaderProblem.DuplicatePropertyLoaderProblem(this, appConfigDef.getGroupForProperty(prop), prop));
                }
            }
        }
    }

    protected PropertyValue findDuplicateProperty(PropertyValue current, List<PropertyValue> values) {
        for (PropertyValue ref : values) {
            if (!current.getProperty().equals(ref.getProperty())) continue;
            return ref;
        }
        return null;
    }

    protected <T> PropertyValue createValue(ConstructionDefinition appConfigDef, Property<T> prop, String untrimmedString) throws ParsingException {
        ProblemList<Problem> problems = new ProblemList<Problem>();
        Object value = null;
        String trimmed = untrimmedString;
        if (prop.getValueType().getDestinationType().equals(String.class) && this.isTrimmingRequiredForStringValues()) {
            trimmed = prop.getTrimmer().trim(untrimmedString);
        }
        if (trimmed != null || prop.getPropertyType().isFlag()) {
            value = prop.getValueType().parse(trimmed);
            for (Validator<Object> validator : prop.getValidators()) {
                if (validator.isValid(value)) continue;
                problems.add(new ValueProblem.InvalidValueProblem<Object>(this, (Class<BasePropertyGroup>)appConfigDef.getGroupForProperty(prop), (Property<Object>)prop, value, (Validator<Object>)validator));
            }
        } else {
            return null;
        }
        return new PropertyValue(prop, value, problems);
    }
}

