/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.Arrays;
import java.util.List;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.load.BaseLoader;

public class FixedValueLoader
extends BaseLoader {
    List<PropertyValue> values;

    public FixedValueLoader(List<PropertyValue> values) {
        this.values = values;
    }

    public FixedValueLoader(PropertyValue ... values) {
        this.values = Arrays.asList(values);
    }

    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        return new LoaderValues(this, this.values, ProblemList.EMPTY_PROBLEM_LIST);
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public boolean isUnrecognizedPropertyNamesConsideredAProblem() {
        return true;
    }

    @Override
    public String getSpecificLoadDescription() {
        return "a list of fixed values passed in by the construction code (not dynamically loaded)";
    }

    @Override
    public String getLoaderType() {
        return "FixedValue";
    }

    @Override
    public String getLoaderDialect() {
        return "FromJavaSourceCode";
    }
}

