/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.yarnandtail.andhow.GroupInfo;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.ValueMap;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.load.BaseLoader;
import org.yarnandtail.andhow.property.QuotedSpacePreservingTrimmer;
import org.yarnandtail.andhow.property.StrProp;
import org.yarnandtail.andhow.sample.JndiLoaderSamplePrinter;
import org.yarnandtail.andhow.util.TextUtil;

public class JndiLoader
extends BaseLoader {
    static String JNDI_PROTOCOL_NAME = "java:";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        List<String> jndiRoots = this.buildJndiRoots(existingValues);
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        ProblemList<Problem> problems = new ProblemList<Problem>();
        try {
            InitialContext ctx = new InitialContext();
            ArrayList propNames = new ArrayList();
            for (Property<?> prop : appConfigDef.getProperties()) {
                List<String> propJndiNames = this.buildJndiNames(appConfigDef, jndiRoots, prop);
                for (String propName : propJndiNames) {
                    try {
                        Object o = ctx.lookup(propName);
                        if (o == null) continue;
                        this.attemptToAdd(appConfigDef, values, problems, prop, o);
                    }
                    catch (NameNotFoundException o) {
                    }
                    catch (NamingException ne) {
                        if (ne.getRootCause() instanceof NameNotFoundException) continue;
                        throw ne;
                    }
                }
                continue;
                return new LoaderValues(this, values, problems);
            }
        }
        catch (NamingException ex) {
            problems.add(new LoaderProblem.JndiContextLoaderProblem(this));
        }
        return new LoaderValues(this, values, problems);
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public boolean isUnrecognizedPropertyNamesConsideredAProblem() {
        return false;
    }

    @Override
    public String getSpecificLoadDescription() {
        return "JNDI properties in the system-wide JNDI context";
    }

    @Override
    public Class<? extends BasePropertyGroup> getClassConfig() {
        return CONFIG.class;
    }

    @Override
    public SamplePrinter getConfigSamplePrinter() {
        return new JndiLoaderSamplePrinter();
    }

    protected List<String> buildJndiRoots(ValueMap values) {
        List<String> addRoots;
        ArrayList<String> myJndiRoots = new ArrayList<String>();
        if (CONFIG.ADDED_JNDI_ROOTS.getValue(values) != null) {
            addRoots = this.split((String)CONFIG.ADDED_JNDI_ROOTS.getValue(values));
            myJndiRoots.addAll(addRoots);
        }
        addRoots = this.split((String)CONFIG.STANDARD_JNDI_ROOTS.getValue(values));
        myJndiRoots.addAll(addRoots);
        return myJndiRoots;
    }

    protected List<String> buildJndiNames(ConstructionDefinition appConfigDef, List<String> roots, Property prop) {
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> propJndiNames = new ArrayList<String>();
        if (appConfigDef.getNamingStrategy().isUriNameDistict(appConfigDef.getCanonicalName(prop))) {
            propNames.add(appConfigDef.getNamingStrategy().getUriName(appConfigDef.getCanonicalName(prop)));
        }
        propNames.add(appConfigDef.getCanonicalName(prop));
        appConfigDef.getAliases(prop).stream().filter(a -> a.isIn()).forEach(a -> {
            propNames.add(a.getActualName());
            if (appConfigDef.getNamingStrategy().isUriNameDistict(a.getActualName())) {
                propNames.add(appConfigDef.getNamingStrategy().getUriName(a.getActualName()));
            }
        });
        for (String root : roots) {
            for (String propName : propNames) {
                propJndiNames.add(root + propName);
            }
        }
        return propJndiNames;
    }

    protected List<String> split(String rootStr) {
        ArrayList<String> cleanRoots = new ArrayList<String>();
        if (rootStr != null) {
            QuotedSpacePreservingTrimmer trimmer = QuotedSpacePreservingTrimmer.instance();
            String[] roots = rootStr.split(",");
            for (int i = 0; i < roots.length; ++i) {
                String s = trimmer.trim(roots[i]);
                if (s == null) continue;
                cleanRoots.add(s);
            }
            return cleanRoots;
        }
        return TextUtil.EMPTY_STRING_LIST;
    }

    @Override
    public String getLoaderType() {
        return "JNDI";
    }

    @Override
    public String getLoaderDialect() {
        return null;
    }

    @GroupInfo(name="JndiLoader Configuration", desc="Since JNDI providers use different base URIs to store entries, base URIs must be configurable. The most common URI roots are \"java:\", \"java:comp/env/\" or just \"\".To preserve whitespace or indicate an empty string, use double quotes around an individual comma separated value.If your container/provider uses something different, set one of these properties. All configured JNDI roots will be searched for each application property.Typically there are multiple roots to search and multiple forms of property names, leading to the possibility of duplicate/conflicting JNDI entries. If multiple entries are found in JNDI for a property, a runtime error is thrown at startup.")
    public static interface CONFIG
    extends BasePropertyGroup {
        public static final StrProp STANDARD_JNDI_ROOTS = ((StrProp.StrBuilder)((StrProp.StrBuilder)((StrProp.StrBuilder)((StrProp.StrBuilder)StrProp.builder().defaultValue("java:comp/env/,java:,\"\"")).required()).desc("A comma separated list of standard JNDI root locations to be searched for properties. Setting this property will replace the standard list, use ADDED_JNDI_ROOTS to only add to the list. ")).helpText("The final JNDI URIs to be searched will look like this '[root][Property Name]'")).build();
        public static final StrProp ADDED_JNDI_ROOTS = ((StrProp.StrBuilder)((StrProp.StrBuilder)StrProp.builder().desc("A comma separated list of JNDI root locations to be prepended to the standard list for searching. Setting this property does not affect the STANDARD_JNDI_ROOTS.")).helpText("The final JNDI URIs to be searched will look like this '[root][Property Name]'")).build();
    }
}

