/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.property;

import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.AndHow;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyType;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueMap;
import org.yarnandtail.andhow.api.ValueType;

public abstract class PropertyBase<T>
implements Property<T> {
    private final PropertyType paramType;
    private final ValueType<T> valueType;
    private final Trimmer trimmer;
    private final T defaultValue;
    private final boolean required;
    private final String shortDesc;
    private final List<Validator<T>> validators;
    private final List<Name> aliases;
    private final String helpText;

    public PropertyBase(T defaultValue, boolean required, String shortDesc, List<Validator<T>> validators, List<Name> aliases, PropertyType paramType, ValueType<T> valueType, Trimmer trimmer, String helpText) {
        this.paramType = paramType;
        this.valueType = valueType;
        this.trimmer = trimmer;
        this.defaultValue = defaultValue;
        this.required = required;
        this.shortDesc = shortDesc != null ? shortDesc : "";
        this.validators = validators != null ? Collections.unmodifiableList(validators) : Collections.emptyList();
        this.aliases = aliases != null ? Collections.unmodifiableList(aliases) : Collections.emptyList();
        this.helpText = helpText != null ? helpText : "";
    }

    @Override
    public PropertyType getPropertyType() {
        return this.paramType;
    }

    @Override
    public ValueType<T> getValueType() {
        return this.valueType;
    }

    @Override
    public Trimmer getTrimmer() {
        return this.trimmer;
    }

    @Override
    public String getShortDescription() {
        return this.shortDesc;
    }

    @Override
    public List<Validator<T>> getValidators() {
        return this.validators;
    }

    @Override
    public List<Name> getRequestedAliases() {
        return this.aliases;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public T getValue(ValueMap values) {
        T v = this.getExplicitValue(values);
        if (v != null) {
            return v;
        }
        return this.getDefaultValue();
    }

    @Override
    public final T getValue() {
        return this.getValue(AndHow.instance());
    }

    @Override
    public T getExplicitValue(ValueMap values) {
        Object v = values.getExplicitValue(this);
        return this.valueType.cast(v);
    }

    @Override
    public final T getExplicitValue() {
        return this.getExplicitValue(AndHow.instance());
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }
}

