/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.property;

import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueType;

public abstract class PropertyBuilderBase<B extends PropertyBuilderBase, P extends Property<T>, T> {
    protected B instance;
    protected ValueType<T> _valueType;
    protected Trimmer _trimmer;
    protected T _defaultValue;
    protected boolean _required = false;
    protected String _shortDesc;
    protected List<Validator<T>> _validators = new ArrayList<Validator<T>>();
    protected List<Name> _aliases = new ArrayList<Name>();
    protected String _helpText;

    protected void setInstance(B instance) {
        this.instance = instance;
    }

    public B valueType(ValueType<T> valueType) {
        this._valueType = valueType;
        return this.instance;
    }

    public B trimmer(Trimmer trimmer) {
        this._trimmer = trimmer;
        return this.instance;
    }

    public B defaultValue(T defaultValue) {
        this._defaultValue = defaultValue;
        return this.instance;
    }

    public B setRequired(boolean required) {
        this._required = required;
        return this.instance;
    }

    public B required() {
        this._required = true;
        return this.instance;
    }

    public B desc(String shortDesc) {
        return this.description(shortDesc);
    }

    public B description(String shortDesc) {
        this._shortDesc = shortDesc;
        return this.instance;
    }

    public B validation(Validator<T> validator) {
        this._validators.add(validator);
        return this.instance;
    }

    public B validations(List<Validator<T>> validators) {
        this._validators.addAll(validators);
        return this.instance;
    }

    public B aliasIn(String name) {
        this.addAlias(new Name(name, true, false), this._aliases);
        return this.instance;
    }

    public B aliasOut(String name) {
        this.addAlias(new Name(name, false, true), this._aliases);
        return this.instance;
    }

    public B aliasInAndOut(String name) {
        this.addAlias(new Name(name, true, true), this._aliases);
        return this.instance;
    }

    protected void addAlias(Name newAlias, List<Name> addToList) {
        String name = newAlias.getActualName();
        for (int i = 0; i < addToList.size(); ++i) {
            Name a = addToList.get(i);
            if (!a.getActualName().equals(name)) continue;
            Name b = new Name(name, newAlias.isIn() || a.isIn(), newAlias.isOut() || a.isOut());
            addToList.set(i, b);
            return;
        }
        addToList.add(newAlias);
    }

    public B helpText(String helpText) {
        this._helpText = helpText;
        return this.instance;
    }

    public abstract P build();
}

