/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.sample.BaseSamplePrinter;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.sample.TextBlock;
import org.yarnandtail.andhow.util.AndHowUtil;
import org.yarnandtail.andhow.util.TextUtil;

public class PropFileLoaderSamplePrinter
extends BaseSamplePrinter
implements SamplePrinter {
    protected PrintFormat format = new PrintFormat();

    public PropFileLoaderSamplePrinter() {
        this.format.blockCommentStart = null;
        this.format.blockCommentEnd = null;
        this.format.blockCommentSeparator = null;
        this.format.lineCommentPrefix = "#";
        this.format.lineCommentPrefixSeparator = " ";
        this.format.secondLineIndent = "\t";
        this.format.hr = TextUtil.repeat("##", 45);
        this.format.lineWidth = 90;
    }

    @Override
    public PrintFormat getFormat() {
        return this.format;
    }

    @Override
    public TextBlock getSampleFileStart() {
        return null;
    }

    @Override
    public TextBlock getSampleStartComment(ConstructionDefinition definition) {
        TextBlock tb = new TextBlock(true, true);
        tb.addHR();
        tb.addLine("Sample properties file generated by AndHow!");
        tb.addLine("strong.simple.valid.AppConfiguration  -  https://github.com/eeverman/andhow");
        tb.addLine("Note: " + definition.getNamingStrategy().getNameMatchingDescription());
        tb.addHR();
        return tb;
    }

    @Override
    public String getInAliaseString(ConstructionDefinition definition, EffectiveName name) {
        return name.getActualName();
    }

    @Override
    public TextBlock getActualProperty(ConstructionDefinition definition, Class<? extends BasePropertyGroup> group, Property prop) throws Exception {
        TextBlock tb = new TextBlock(false, false);
        String propCanonName = AndHowUtil.getCanonicalName(group, prop);
        if (prop.getDefaultValue() != null) {
            tb.addLine(TextUtil.format("{} = {}", propCanonName, prop.getDefaultValue()));
        } else {
            tb.addLine(TextUtil.format("{} = [{}]", propCanonName, prop.getValueType().getDestinationType().getSimpleName()));
        }
        return tb;
    }

    @Override
    public TextBlock getSampleFileEnd() {
        return null;
    }
}

