/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.valid;

import org.yarnandtail.andhow.api.Validator;

public abstract class DblValidator
implements Validator<Double> {
    @Override
    public boolean isSpecificationValid() {
        return true;
    }

    @Override
    public String getInvalidSpecificationMessage() {
        return "THIS VALIDATION IS ALWAYS VALID";
    }

    public static class LessThanOrEqualTo
    extends DblValidator {
        double ref;

        public LessThanOrEqualTo(double ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Double value) {
            if (value != null) {
                return value <= this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be less than or equal to " + Double.toString(this.ref);
        }
    }

    public static class LessThan
    extends DblValidator {
        double ref;

        public LessThan(double ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Double value) {
            if (value != null) {
                return value < this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be less than " + Double.toString(this.ref);
        }
    }

    public static class GreaterThanOrEqualTo
    extends DblValidator {
        double ref;

        public GreaterThanOrEqualTo(double ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Double value) {
            if (value != null) {
                return value >= this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be greater than or equal to " + Double.toString(this.ref);
        }
    }

    public static class GreaterThan
    extends DblValidator {
        double ref;

        public GreaterThan(double ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Double value) {
            if (value != null) {
                return value > this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be greater than " + Double.toString(this.ref);
        }
    }
}

