/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.Name;

public class EffectiveName
extends Name {
    private final String effectiveIn;
    private final String effectiveOut;

    public EffectiveName(String actual, String effectiveIn, boolean in, boolean out) {
        super(actual, in, out);
        if (effectiveIn == null || effectiveIn.length() == 0) {
            throw new AppFatalException("The effective 'in' name cannot be empty or null");
        }
        if (!Name.isValidPropertyName(effectiveIn)) {
            throw new AppFatalException("The effective 'in' name cannot contain whitespace or special characters from this list: " + Name.ILLEGAL_PROPERTY_NAME_CHARS);
        }
        this.effectiveIn = effectiveIn;
        this.effectiveOut = actual;
    }

    public EffectiveName(String actual, String effectiveIn, String effectiveOut, boolean in, boolean out) {
        super(actual, in, out);
        if (effectiveIn == null || effectiveIn.length() == 0) {
            throw new AppFatalException("The effective 'in' name cannot be empty or null");
        }
        if (!Name.isValidPropertyName(effectiveIn)) {
            throw new AppFatalException("The effective 'in' name cannot contain whitespace or special characters from this list: " + Name.ILLEGAL_PROPERTY_NAME_CHARS);
        }
        if (effectiveOut == null || effectiveOut.length() == 0) {
            throw new AppFatalException("The effective 'out' name cannot be empty or null");
        }
        if (!Name.isValidPropertyName(effectiveOut)) {
            throw new AppFatalException("The effective 'out' name cannot contain whitespace or special characters from this list: " + Name.ILLEGAL_PROPERTY_NAME_CHARS);
        }
        this.effectiveIn = effectiveIn;
        this.effectiveOut = effectiveOut;
    }

    public String getEffectiveInName() {
        return this.effectiveIn;
    }

    public String getEffectiveOutName() {
        return this.effectiveOut;
    }
}

