/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import com.sun.source.util.Trees;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.yarnandtail.andhow.AndHowInit;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.compile.AndHowElementScanner7;
import org.yarnandtail.andhow.compile.CompileUnit;
import org.yarnandtail.andhow.compile.PropertyRegistrarClassGenerator;
import org.yarnandtail.andhow.compile.TooManyInitClassesException;
import org.yarnandtail.andhow.service.PropertyRegistrar;
import org.yarnandtail.andhow.service.PropertyRegistration;
import org.yarnandtail.andhow.service.PropertyRegistrationList;
import org.yarnandtail.andhow.util.AndHowLog;

@SupportedAnnotationTypes(value={"*"})
public class AndHowCompileProcessor
extends AbstractProcessor {
    private static final AndHowLog LOG = AndHowLog.getLogger(AndHowCompileProcessor.class);
    private static final String INIT_CLASS_NAME = AndHowInit.class.getCanonicalName();
    private static final String TEST_INIT_CLASS_NAME = "org.yarnandtail.andhow.AndHowTestInit";
    private static final String SERVICES_PACKAGE = "";
    private static final String SERVICE_REGISTRY_META_DIR = "META-INF/services/";
    private static Calendar runDate;
    private Trees trees;
    private final List<CauseEffect> registrars = new ArrayList<CauseEffect>();
    private final List<CauseEffect> initClasses = new ArrayList<CauseEffect>();
    private final List<CauseEffect> testInitClasses = new ArrayList<CauseEffect>();

    public AndHowCompileProcessor() {
        runDate = new GregorianCalendar();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean isLastRound = roundEnv.processingOver();
        Filer filer = this.processingEnv.getFiler();
        if (isLastRound) {
            LOG.debug("Final round of annotation processing.  Total root element count: {0}", roundEnv.getRootElements().size());
            try {
                if (this.initClasses.size() == 1) {
                    LOG.info("Found exactly 1 {0} class: {1}", INIT_CLASS_NAME, this.initClasses.get((int)0).fullClassName);
                    this.writeServiceFile(filer, AndHowInit.class.getCanonicalName(), this.initClasses);
                } else if (this.initClasses.size() > 1) {
                    TooManyInitClassesException err = new TooManyInitClassesException(INIT_CLASS_NAME, this.initClasses);
                    err.writeDetails(LOG);
                    throw err;
                }
                if (this.testInitClasses.size() == 1) {
                    LOG.info("Found exactly 1 {0} class: {1}", TEST_INIT_CLASS_NAME, this.testInitClasses.get((int)0).fullClassName);
                    this.writeServiceFile(filer, TEST_INIT_CLASS_NAME, this.testInitClasses);
                } else if (this.testInitClasses.size() > 1) {
                    TooManyInitClassesException err = new TooManyInitClassesException(TEST_INIT_CLASS_NAME, this.testInitClasses);
                    err.writeDetails(LOG);
                    throw err;
                }
                if (this.registrars == null || this.registrars.size() <= 0) return false;
                this.writeServiceFile(filer, PropertyRegistrar.class.getCanonicalName(), this.registrars);
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while trying to write generated files", e);
            }
        }
        LOG.trace("Another round of annotation processing.  Current root element count: {0}", roundEnv.getRootElements().size());
        Iterator<? extends Element> it = roundEnv.getRootElements().iterator();
        for (Element element : roundEnv.getRootElements()) {
            TypeElement te = (TypeElement)element;
            AndHowElementScanner7 st = new AndHowElementScanner7(this.processingEnv, Property.class.getCanonicalName(), INIT_CLASS_NAME, TEST_INIT_CLASS_NAME);
            CompileUnit ret = (CompileUnit)st.scan(element);
            if (ret.istestInitClass()) {
                this.testInitClasses.add(new CauseEffect(ret.getRootCanonicalName(), te));
            } else if (ret.isInitClass()) {
                this.initClasses.add(new CauseEffect(ret.getRootCanonicalName(), te));
            }
            if (ret.hasRegistrations()) {
                LOG.debug("Found {0} AndHow Properties in class {1} ", ret.getRegistrations().size(), ret.getRootCanonicalName());
                PropertyRegistrarClassGenerator gen = new PropertyRegistrarClassGenerator(ret, AndHowCompileProcessor.class, runDate);
                this.registrars.add(new CauseEffect(gen.buildGeneratedClassFullName(), te));
                PropertyRegistrationList regs = ret.getRegistrations();
                if (LOG.isLoggable(Level.FINEST)) {
                    for (PropertyRegistration p : ret.getRegistrations()) {
                        LOG.trace("Found AndHow Property ''{0}'' in root class ''{1}'', immediate parent is ''{2}''", p.getCanonicalPropertyName(), p.getCanonicalRootName(), p.getJavaCanonicalParentName());
                    }
                }
                try {
                    this.writeClassFile(filer, gen, element);
                    LOG.trace("Wrote new generated class file " + gen.buildGeneratedClassSimpleName());
                }
                catch (Exception ex) {
                    LOG.error("Unable to write generated classfile '" + gen.buildGeneratedClassFullName() + "'", ex);
                    throw new RuntimeException(ex);
                }
            }
            if (ret.getErrors().size() <= 0) continue;
            LOG.error("AndHow Property definition errors prevented compilation to complete. Each of the following errors must be fixed before compilation is possible.");
            for (String err : ret.getErrors()) {
                LOG.error("AndHow Property Error: {0}", err);
            }
            throw new RuntimeException("AndHowCompileProcessor threw a fatal exception - See error log for details.");
        }
        return false;
    }

    public void writeClassFile(Filer filer, PropertyRegistrarClassGenerator generator, Element causingElement) throws Exception {
        String classContent = generator.generateSource();
        JavaFileObject classFile = filer.createSourceFile(generator.buildGeneratedClassFullName(), causingElement);
        try (Writer writer = classFile.openWriter();){
            writer.write(classContent);
        }
    }

    protected void writeServiceFile(Filer filer, String fullyQualifiedServiceInterfaceName, List<CauseEffect> implementingClasses) throws IOException {
        HashSet<Element> set = new HashSet<Element>();
        for (CauseEffect ce : implementingClasses) {
            set.add(ce.causeElement);
        }
        FileObject svsFile = filer.createResource(StandardLocation.CLASS_OUTPUT, SERVICES_PACKAGE, SERVICE_REGISTRY_META_DIR + fullyQualifiedServiceInterfaceName, set.toArray(new Element[set.size()]));
        try (Writer writer = svsFile.openWriter();){
            for (CauseEffect ce : implementingClasses) {
                writer.write(ce.fullClassName);
                writer.write(System.lineSeparator());
            }
        }
    }

    protected static class CauseEffect {
        String fullClassName;
        Element causeElement;

        public CauseEffect(String fullClassName, Element causeElement) {
            this.fullClassName = fullClassName;
            this.causeElement = causeElement;
        }
    }
}

