/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.internal.LoaderValueCoord;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class ValueProblem
implements Problem {
    protected LoaderValueCoord badValueCoord;

    public LoaderValueCoord getBadValueCoord() {
        return this.badValueCoord;
    }

    @Override
    public String getFullMessage() {
        return this.getProblemContext() + ": " + this.getProblemDescription();
    }

    @Override
    public String getProblemContext() {
        if (this.badValueCoord != null) {
            String loadDesc = "[[Unknown]]";
            if (this.badValueCoord.getLoader() != null && this.badValueCoord.getLoader().getSpecificLoadDescription() != null) {
                loadDesc = this.badValueCoord.getLoader().getSpecificLoadDescription();
            }
            return TextUtil.format("Property {} loaded from {}", this.badValueCoord.getPropName(), loadDesc);
        }
        return "[[Unknown]]";
    }

    public static class InvalidValueProblem<T>
    extends ValueProblem {
        LoaderValueCoord def;
        Validator<T> validator;
        T value;

        public InvalidValueProblem(Loader loader, Class<?> group, Property<T> prop, T value, Validator<T> validator) {
            this.badValueCoord = new LoaderValueCoord(loader, group, prop);
            this.validator = validator;
            this.value = value;
        }

        @Override
        public String getProblemDescription() {
            return this.validator.getInvalidMessage(this.value);
        }
    }
}

