/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.ReadLoader;
import org.yarnandtail.andhow.api.StaticPropertyConfiguration;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.load.BaseLoader;
import org.yarnandtail.andhow.load.KVP;

public class KeyValuePairLoader
extends BaseLoader
implements ReadLoader {
    protected boolean unknownPropertyAProblem = true;
    public static final String KVP_DELIMITER = "=";
    private List<String> keyValuePairs = new ArrayList<String>();

    public void setKeyValuePairs(List<String> keyValuePairs) {
        if (keyValuePairs != null && keyValuePairs.size() > 0) {
            this.keyValuePairs.clear();
            this.keyValuePairs.addAll(keyValuePairs);
        }
    }

    public void setKeyValuePairs(String ... keyValuePairs) {
        if (keyValuePairs != null && keyValuePairs.length > 0) {
            this.keyValuePairs.addAll(Arrays.asList(keyValuePairs));
        }
    }

    @Override
    public LoaderValues load(StaticPropertyConfiguration appConfigDef, ValidatedValuesWithContext existingValues) {
        ArrayList<ValidatedValue> values = new ArrayList<ValidatedValue>();
        ProblemList<Problem> problems = new ProblemList<Problem>();
        if (this.keyValuePairs != null) {
            for (String s : this.keyValuePairs) {
                try {
                    KVP kvp = KVP.splitKVP(s, KVP_DELIMITER);
                    this.attemptToAdd(appConfigDef, values, problems, kvp.getName(), kvp.getValue());
                }
                catch (ParsingException e) {
                    problems.add(new LoaderProblem.ParsingLoaderProblem(this, null, null, e));
                }
            }
            values.trimToSize();
        }
        return new LoaderValues(this, values, problems);
    }

    @Override
    public String getSpecificLoadDescription() {
        return "string key value pairs";
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return true;
    }

    @Override
    public String getLoaderType() {
        return "KeyValuePair";
    }

    @Override
    public String getLoaderDialect() {
        return null;
    }

    @Override
    public void setUnknownPropertyAProblem(boolean isAProblem) {
        this.unknownPropertyAProblem = isAProblem;
    }

    @Override
    public boolean isUnknownPropertyAProblem() {
        return this.unknownPropertyAProblem;
    }

    @Override
    public void releaseResources() {
        this.keyValuePairs = null;
    }
}

