/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.property;

import java.util.List;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.PropertyType;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueType;
import org.yarnandtail.andhow.property.PropertyBase;
import org.yarnandtail.andhow.property.PropertyBuilderBase;
import org.yarnandtail.andhow.property.TrimToNullTrimmer;
import org.yarnandtail.andhow.valid.LngValidator;
import org.yarnandtail.andhow.valuetype.LngType;

public class LngProp
extends PropertyBase<Long> {
    public LngProp(Long defaultValue, boolean required, String shortDesc, List<Validator<Long>> validators, List<Name> aliases, PropertyType paramType, ValueType<Long> valueType, Trimmer trimmer, String helpText) {
        super(defaultValue, required, shortDesc, validators, aliases, paramType, valueType, trimmer, helpText);
    }

    public static LngBuilder builder() {
        return new LngBuilder();
    }

    public static class LngBuilder
    extends PropertyBuilderBase<LngBuilder, LngProp, Long> {
        public LngBuilder() {
            this.instance = this;
            this.valueType(LngType.instance());
            this.trimmer(TrimToNullTrimmer.instance());
        }

        @Override
        public LngProp build() {
            return new LngProp((Long)this._defaultValue, this._nonNull, this._desc, this._validators, (List<Name>)this._aliases, PropertyType.SINGLE_NAME_VALUE, this._valueType, this._trimmer, this._helpText);
        }

        public LngBuilder mustBeGreaterThan(long reference) {
            this.validation(new LngValidator.GreaterThan(reference));
            return (LngBuilder)this.instance;
        }

        public LngBuilder mustBeGreaterThanOrEqualTo(long reference) {
            this.validation(new LngValidator.GreaterThanOrEqualTo(reference));
            return (LngBuilder)this.instance;
        }

        public LngBuilder mustBeLessThan(long reference) {
            this.validation(new LngValidator.LessThan(reference));
            return (LngBuilder)this.instance;
        }

        public LngBuilder mustBeLessThanOrEqualTo(long reference) {
            this.validation(new LngValidator.LessThanOrEqualTo(reference));
            return (LngBuilder)this.instance;
        }
    }
}

