/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import java.util.ArrayList;
import org.yarnandtail.andhow.sample.TextLine;

public class TextBlock {
    private boolean wrap;
    private boolean comment;
    private boolean blankLineBefore = false;
    private boolean blankLineAfter = false;
    private ArrayList<TextLine> lines = new ArrayList();

    public TextBlock(boolean wrap, boolean comment) {
        this.wrap = wrap;
        this.comment = comment;
    }

    public TextBlock(boolean wrap, boolean comment, boolean blankLineBefore, boolean blankLineAfter) {
        this(wrap, comment);
        this.blankLineBefore = blankLineBefore;
        this.blankLineAfter = blankLineAfter;
    }

    public TextBlock addLine(TextLine line) {
        this.lines.add(line);
        if (line.wrap == null) {
            line.wrap = this.wrap;
        }
        return this;
    }

    public TextBlock addLine(String strLine) {
        TextLine.StringLine line = new TextLine.StringLine(strLine, this.wrap);
        this.lines.add(line);
        return this;
    }

    public TextBlock addHR() {
        this.lines.add(new TextLine.HRLine());
        return this;
    }

    public TextBlock addBlank() {
        this.lines.add(new TextLine.BlankLine());
        return this;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public boolean isComment() {
        return this.comment;
    }

    public ArrayList<TextLine> getLines() {
        return this.lines;
    }

    public TextLine getLine(int i) {
        return this.lines.get(i);
    }

    public boolean isBlankLineBefore() {
        return this.blankLineBefore;
    }

    public boolean isBlankLineAfter() {
        return this.blankLineAfter;
    }

    public void setBlankLineBefore(boolean blankLineBefore) {
        this.blankLineBefore = blankLineBefore;
    }

    public void setBlankLineAfter(boolean blankLineAfter) {
        this.blankLineAfter = blankLineAfter;
    }
}

