package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.internal.StaticPropertyConfigurationInternal;
import org.yarnandtail.andhow.AndHow;
import org.yarnandtail.andhow.api.*;
import org.yarnandtail.andhow.util.TextUtil;

/**
 *
 * @author ericeverman
 */
public class JndiLoaderSamplePrinter extends BaseSamplePrinter implements SamplePrinter {
	protected PrintFormat format;
	
	public JndiLoaderSamplePrinter() {
		format = new PrintFormat();
		format.blockCommentStart = "<!--";
		format.blockCommentEnd = "-->";
		format.blockCommentSeparator = " "; //Use between the last text and the comment end if on same line
		format.lineCommentPrefix = null;
		format.lineCommentPrefixSeparator = " ";	//Separate the opening line comment from the text
		format.secondLineIndent = "\t";
		format.hr = TextUtil.repeat("- ", 45);
		format.lineWidth = 90;
	}
	
	@Override
	public PrintFormat getFormat() {
		return format;
	}
	
	@Override
	public TextBlock getSampleFileStart() {
		TextBlock tb = new TextBlock(false, false);
		tb.addLine("<Context>");
		return tb;
	}
	
	@Override
	public TextBlock getSampleStartComment(StaticPropertyConfigurationInternal definition) {
		TextBlock tb = new TextBlock(true, true);
		tb.addHR();
		tb.addLine("Sample JNDI config file generated by " +  AndHow.ANDHOW_NAME);
		tb.addLine(AndHow.ANDHOW_TAG_LINE + "  -  " + AndHow.ANDHOW_URL);
		tb.addLine("This sample uses Tomcat syntax. JNDI configuration for other servers will be similar.");
		tb.addHR();
		return tb;
	}
	
	@Override
	public String getInAliaseString(StaticPropertyConfigurationInternal definition, EffectiveName name) {
		return definition.getNamingStrategy().getUriName(name.getActualName());
	}
	
	
	@Override
	public TextBlock getActualProperty(StaticPropertyConfigurationInternal definition, 
			GroupProxy group, Property prop) throws Exception {
		
		TextBlock tb = new TextBlock(false, false);
		
		String propCanonName = definition.getNamingStrategy().getUriName(group.getCanonicalName(prop));
		String type = prop.getValueType().getDestinationType().getCanonicalName();

		
		if (prop.getDefaultValue() != null) {
			tb.addLine(
					TextUtil.format("<Environment name=\"{}\" value=\"{}\" type=\"{}\" override=\"false\"/>", 
						propCanonName, 
						TextUtil.escapeXml(prop.getDefaultValue().toString()),
						type)
			);
		} else {
			tb.addLine(
					TextUtil.format("<Environment name=\"{}\" value=\"[{}]\" type=\"{}\" override=\"false\"/>", 
						propCanonName, 
						prop.getValueType().getDestinationType().getSimpleName(),
						type)
			);
		}
		
		return tb;
	}

	@Override
	public TextBlock getSampleFileEnd() {
		TextBlock tb = new TextBlock(false, false);
		tb.addLine("</Context>");
		return tb;
	}
	
	@Override
	public String getSampleFileExtension() {
		return "xml";
	}
}
