/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import org.yarnandtail.andhow.api.AppFatalException;

public class Name {
    public static String ILLEGAL_PROPERTY_NAME_CHARS = " \t\n\r;/?:@=&\"<>#%{}|\\^~[]`";
    private final boolean in;
    private final boolean out;
    private final String actual;

    public Name(String name, boolean in, boolean out) {
        if (name == null || name.length() == 0) {
            throw new AppFatalException("The name cannot be empty or null");
        }
        if (!Name.isValidPropertyName(name)) {
            throw new AppFatalException("Names cannot contain whitespace or special characters from this list: " + ILLEGAL_PROPERTY_NAME_CHARS);
        }
        this.in = in;
        this.out = out;
        this.actual = name;
    }

    public boolean isIn() {
        return this.in;
    }

    public boolean isOut() {
        return this.out;
    }

    public String getActualName() {
        return this.actual;
    }

    public static boolean isValidPropertyName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.startsWith(".") || name.endsWith(".")) {
            return false;
        }
        for (char c : ILLEGAL_PROPERTY_NAME_CHARS.toCharArray()) {
            if (name.indexOf(c) <= -1) continue;
            return false;
        }
        return true;
    }
}

