/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ReadLoader;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.internal.StaticPropertyConfigurationInternal;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class BaseLoader
implements Loader {
    @Override
    public Class<?> getClassConfig() {
        return null;
    }

    @Override
    public List<Property> getInstanceConfig() {
        return Collections.emptyList();
    }

    @Override
    public SamplePrinter getConfigSamplePrinter() {
        return null;
    }

    protected void attemptToAdd(StaticPropertyConfigurationInternal appConfigDef, List<ValidatedValue> values, ProblemList<Problem> loaderProblems, String key, String strValue) {
        if ((key = TextUtil.trimToNull(key)) != null) {
            ReadLoader rl;
            String effKey = appConfigDef.getNamingStrategy().toEffectiveName(key);
            Property<?> prop = appConfigDef.getProperty(effKey);
            if (prop != null) {
                ValidatedValue pv = null;
                try {
                    pv = this.createValue(appConfigDef, prop, strValue);
                }
                catch (ParsingException e) {
                    loaderProblems.add(new LoaderProblem.StringConversionLoaderProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop, e.getProblemText()));
                }
                if (pv != null) {
                    ValidatedValue dup = this.findDuplicateProperty(pv, values);
                    if (dup == null) {
                        values.add(pv);
                    } else {
                        loaderProblems.add(new LoaderProblem.DuplicatePropertyLoaderProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop));
                    }
                }
            } else if (this instanceof ReadLoader && (rl = (ReadLoader)((Object)this)).isUnknownPropertyAProblem()) {
                loaderProblems.add(new LoaderProblem.UnknownPropertyLoaderProblem(this, key));
            }
        }
    }

    protected void attemptToAdd(StaticPropertyConfigurationInternal appConfigDef, List<ValidatedValue> values, ProblemList<Problem> loaderProblems, Property prop, Object value) {
        if (prop != null) {
            ValidatedValue pv = null;
            if (value.getClass().equals(prop.getValueType().getDestinationType())) {
                pv = new ValidatedValue(prop, value);
            } else if (value instanceof String) {
                try {
                    pv = this.createValue(appConfigDef, prop, value.toString());
                }
                catch (ParsingException e) {
                    loaderProblems.add(new LoaderProblem.StringConversionLoaderProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop, e.getProblemText()));
                }
            } else {
                loaderProblems.add(new LoaderProblem.ObjectConversionValueProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop, value));
            }
            if (pv != null) {
                ValidatedValue dup = this.findDuplicateProperty(pv, values);
                if (dup == null) {
                    values.add(pv);
                } else {
                    loaderProblems.add(new LoaderProblem.DuplicatePropertyLoaderProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop));
                }
            }
        }
    }

    protected ValidatedValue findDuplicateProperty(ValidatedValue current, List<ValidatedValue> values) {
        for (ValidatedValue ref : values) {
            if (!current.getProperty().equals(ref.getProperty())) continue;
            return ref;
        }
        return null;
    }

    protected <T> ValidatedValue createValue(StaticPropertyConfigurationInternal appConfigDef, Property<T> prop, String untrimmedString) throws ParsingException {
        Object value = null;
        String trimmed = untrimmedString;
        if (prop.getValueType().getDestinationType().equals(String.class) && this.isTrimmingRequiredForStringValues()) {
            trimmed = prop.getTrimmer().trim(untrimmedString);
        }
        if (trimmed == null && !prop.getPropertyType().isFlag()) {
            return null;
        }
        value = prop.getValueType().parse(trimmed);
        return new ValidatedValue<Object>((Property<Object>)prop, value);
    }

    @Override
    public void releaseResources() {
    }
}

