/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.PropertyValue;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.ReadLoader;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.StaticPropertyConfigurationInternal;
import org.yarnandtail.andhow.load.BaseLoader;

public class FixedValueLoader
extends BaseLoader
implements ReadLoader {
    protected boolean unknownPropertyAProblem = true;
    protected List<PropertyValue> values = new ArrayList<PropertyValue>();

    public void setPropertyValues(List<PropertyValue> values) {
        if (values != null) {
            this.values.addAll(values);
        }
    }

    public void setPropertyValues(PropertyValue ... values) {
        if (values != null && values.length > 0) {
            this.values.addAll(Arrays.asList(values));
        }
    }

    @Override
    public LoaderValues load(StaticPropertyConfigurationInternal appConfigDef, ValidatedValuesWithContext existingValues) {
        if (this.values != null && this.values.size() > 0) {
            ArrayList<ValidatedValue> vvs = new ArrayList<ValidatedValue>(this.values.size());
            for (int i = 0; i < this.values.size(); ++i) {
                ValidatedValue vv = new ValidatedValue(this.values.get(i).getProperty(), this.values.get(i).getValue());
                vvs.add(vv);
            }
            return new LoaderValues(this, vvs, ProblemList.EMPTY_PROBLEM_LIST);
        }
        return new LoaderValues(this, Collections.emptyList(), ProblemList.EMPTY_PROBLEM_LIST);
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public String getSpecificLoadDescription() {
        return "a list of fixed values passed in by the construction code (not dynamically loaded)";
    }

    @Override
    public String getLoaderType() {
        return "FixedValue";
    }

    @Override
    public String getLoaderDialect() {
        return "FromJavaSourceCode";
    }

    @Override
    public void setUnknownPropertyAProblem(boolean isAProblem) {
        this.unknownPropertyAProblem = isAProblem;
    }

    @Override
    public boolean isUnknownPropertyAProblem() {
        return this.unknownPropertyAProblem;
    }

    @Override
    public void releaseResources() {
        this.values = null;
    }
}

