/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.internal.StaticPropertyConfigurationInternal;
import org.yarnandtail.andhow.load.LoaderException;
import org.yarnandtail.andhow.load.PropFileBaseLoader;
import org.yarnandtail.andhow.util.TextUtil;

public class PropFileOnFilesystemLoader
extends PropFileBaseLoader {
    String specificLoadDescription = null;

    @Override
    public LoaderValues load(StaticPropertyConfigurationInternal appConfigDef, ValidatedValuesWithContext existingValues) {
        String path = this.getEffectivePath(existingValues);
        if (path != null) {
            this.specificLoadDescription = TextUtil.format("file on the file system at path : {} ({})", path, this.getAbsPath(path));
            LoaderValues vals = this.load(appConfigDef, existingValues, path);
            return vals;
        }
        this.specificLoadDescription = "unpsecified file in the filesystem";
        return new LoaderValues(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoaderValues load(StaticPropertyConfigurationInternal appConfigDef, ValidatedValuesWithContext existingValues, String path) {
        if (path == null) return new LoaderValues(this);
        try {
            File propFile = new File(path);
            try (FileInputStream inS = new FileInputStream(propFile);){
                LoaderValues loaderValues = this.loadInputStreamToProps(inS, path, appConfigDef, existingValues);
                return loaderValues;
            }
            catch (FileNotFoundException e) {
                if (!this.isMissingFileAProblem()) return new LoaderValues(this);
                return new LoaderValues(this, new LoaderProblem.SourceNotFoundLoaderProblem(this, "Expected file on filesystem:" + path));
            }
        }
        catch (LoaderException e) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, e.getCause(), "filesystem:" + path));
        }
        catch (IOException ioe) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, ioe, "filesystem:" + path));
        }
    }

    @Override
    public String getSpecificLoadDescription() {
        if (this.specificLoadDescription != null) {
            return this.specificLoadDescription;
        }
        String path = this.getEffectivePath(null);
        if (path != null) {
            return TextUtil.format("file on the file system at path : {} ({})", path, this.getAbsPath(path));
        }
        return "unconfigured classpath";
    }

    private String getAbsPath(String anything) {
        try {
            File f = new File(anything);
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            return "[Unknown absolute path]";
        }
    }
}

