/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class TextLine {
    protected Boolean wrap;

    abstract String getLine(PrintFormat var1);

    abstract String getLineComment(PrintFormat var1);

    abstract String getBlockComment(PrintFormat var1, boolean var2, boolean var3);

    abstract List<String> getWrappedLine(PrintFormat var1);

    abstract List<String> getWrappedLineComment(PrintFormat var1);

    abstract List<String> getWrappedBlockComment(PrintFormat var1, boolean var2, boolean var3);

    public static class BlankLine
    extends TextLine {
        public BlankLine() {
            this.wrap = false;
        }

        @Override
        public String getLine(PrintFormat format) {
            return "";
        }

        @Override
        public String getLineComment(PrintFormat format) {
            return format.lineCommentPrefix + format.lineCommentPrefixSeparator + "";
        }

        @Override
        public String getBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            String out = "";
            if (startComment) {
                out = format.blockCommentStart + format.blockCommentSeparator + out;
            }
            if (endComment) {
                out = out + format.blockCommentSeparator + format.blockCommentEnd;
            }
            return out;
        }

        @Override
        public List<String> getWrappedLine(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            return lines;
        }

        @Override
        public List<String> getWrappedLineComment(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(format.lineCommentPrefix + format.lineCommentPrefixSeparator + "");
            return lines;
        }

        @Override
        public List<String> getWrappedBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            ArrayList<String> lines = new ArrayList<String>();
            if (startComment && endComment) {
                lines.add(format.blockCommentStart + format.blockCommentSeparator + "" + format.blockCommentSeparator + format.blockCommentEnd);
            } else {
                if (startComment) {
                    lines.add(format.blockCommentStart + format.blockCommentSeparator + "");
                }
                if (endComment) {
                    lines.add("" + format.blockCommentSeparator + format.blockCommentEnd);
                }
            }
            return lines;
        }
    }

    public static class HRLine
    extends TextLine {
        public HRLine() {
            this.wrap = false;
        }

        @Override
        public String getLine(PrintFormat format) {
            return format.hr;
        }

        @Override
        public String getLineComment(PrintFormat format) {
            return format.lineCommentPrefix + format.lineCommentPrefixSeparator + format.hr;
        }

        @Override
        public String getBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            String out = format.hr;
            if (startComment) {
                out = format.blockCommentStart + format.blockCommentSeparator + out;
            }
            if (endComment) {
                out = out + format.blockCommentSeparator + format.blockCommentEnd;
            }
            return out;
        }

        @Override
        public List<String> getWrappedLine(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(format.hr);
            return lines;
        }

        @Override
        public List<String> getWrappedLineComment(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(format.lineCommentPrefix + format.lineCommentPrefixSeparator + format.hr);
            return lines;
        }

        @Override
        public List<String> getWrappedBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            ArrayList<String> lines = new ArrayList<String>();
            if (startComment && endComment) {
                lines.add(format.blockCommentStart + format.blockCommentSeparator + format.hr + format.blockCommentSeparator + format.blockCommentEnd);
            } else {
                if (startComment) {
                    lines.add(format.blockCommentStart + format.blockCommentSeparator + format.hr);
                }
                if (endComment) {
                    lines.add(format.hr + format.blockCommentSeparator + format.blockCommentEnd);
                }
            }
            return lines;
        }
    }

    public static class StringLine
    extends TextLine {
        String line;

        public StringLine(String line, boolean wrap) {
            this.line = line;
            this.wrap = wrap;
        }

        public StringLine(String line) {
            this.line = line;
            this.wrap = null;
        }

        @Override
        public String getLine(PrintFormat format) {
            return this.line;
        }

        @Override
        public String getLineComment(PrintFormat format) {
            return format.lineCommentPrefix + format.lineCommentPrefixSeparator + this.line;
        }

        @Override
        public String getBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            String out = this.line;
            if (startComment) {
                out = format.blockCommentStart + format.blockCommentSeparator + out;
            }
            if (endComment) {
                out = out + format.blockCommentSeparator + format.blockCommentEnd;
            }
            return out;
        }

        @Override
        public List<String> getWrappedLine(PrintFormat format) {
            return TextUtil.wrap(this.line, format.lineWidth, "", format.secondLineIndent);
        }

        @Override
        public List<String> getWrappedLineComment(PrintFormat format) {
            return TextUtil.wrap(this.line, format.lineWidth, format.lineCommentPrefix + format.lineCommentPrefixSeparator, format.secondLineIndent);
        }

        @Override
        public List<String> getWrappedBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            List<String> lines = TextUtil.wrap(this.line, format.lineWidth, "", format.secondLineIndent);
            if (startComment && endComment && lines.size() == 1) {
                lines.set(0, format.blockCommentStart + format.blockCommentSeparator + lines.get(0) + format.blockCommentSeparator + format.blockCommentEnd);
            } else {
                if (startComment) {
                    lines.add(0, format.blockCommentStart);
                }
                if (endComment) {
                    lines.set(lines.size() - 1, lines.get(lines.size() - 1) + format.blockCommentSeparator + format.blockCommentEnd);
                }
            }
            return lines;
        }
    }
}

