/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.Options;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.ExportGroup;
import org.yarnandtail.andhow.api.Exporter;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValues;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.internal.ConstructionProblem;
import org.yarnandtail.andhow.internal.ReportGenerator;
import org.yarnandtail.andhow.internal.RequirementProblem;
import org.yarnandtail.andhow.internal.StaticPropertyConfigurationInternal;
import org.yarnandtail.andhow.internal.StaticPropertyConfigurationMutable;
import org.yarnandtail.andhow.internal.ValidatedValuesWithContextMutable;
import org.yarnandtail.andhow.internal.ValueProblem;
import org.yarnandtail.andhow.name.CaseInsensitiveNaming;
import org.yarnandtail.andhow.util.AndHowLog;
import org.yarnandtail.andhow.util.AndHowUtil;

public class AndHowCore
implements StaticPropertyConfigurationInternal,
ValidatedValues {
    private static final AndHowLog LOG = AndHowLog.getLogger(AndHowCore.class);
    private final List<Loader> loaders = new ArrayList<Loader>();
    private final StaticPropertyConfigurationInternal staticConfig;
    private final ValidatedValuesWithContext loadedValues;
    private final ProblemList<Problem> problems = new ProblemList();

    public AndHowCore(NamingStrategy naming, List<Loader> loaders, List<GroupProxy> registeredGroups) throws AppFatalException {
        NamingStrategy namingStrategy;
        NamingStrategy namingStrategy2 = namingStrategy = naming != null ? naming : new CaseInsensitiveNaming();
        if (loaders != null) {
            for (Loader loader : loaders) {
                if (!this.loaders.contains(loader)) {
                    this.loaders.add(loader);
                    continue;
                }
                this.problems.add(new ConstructionProblem.DuplicateLoader(loader));
            }
        }
        ArrayList<GroupProxy> effRegGroups = new ArrayList<GroupProxy>();
        if (registeredGroups != null && !registeredGroups.isEmpty()) {
            effRegGroups.addAll(registeredGroups);
        } else if (!AndHowUtil.classExists("org.yarnandtail.andhow.compile.AndHowCompileProcessor")) {
            LOG.warn("org.yarnandtail:andhow-annotation-processor is not currently on the classpath.  If it was not present at compile time, AndHow Properties in source code are not discovered and registered. To resolve, add org.yarnandtail:andhow-annotation-processor as a dependency at least at compile time.");
        }
        try {
            GroupProxy options = AndHowUtil.buildGroupProxy(Options.class, false);
            effRegGroups.add(options);
        }
        catch (Exception ex) {
            this.problems.add(new ConstructionProblem.SecurityException(ex, Options.class));
        }
        StaticPropertyConfigurationMutable startupDef = AndHowUtil.buildDefinition(effRegGroups, loaders, namingStrategy, this.problems);
        this.staticConfig = startupDef.toImmutable();
        if (this.problems.size() > 0) {
            AppFatalException afe = new AppFatalException("There is a problem with the basic setup of the AndHow framework. Since it is the framework itself that is misconfigured, no attempt was made to load values. See System.err, out or the log files for more details.", this.problems);
            this.printFailedStartupDetails(afe);
            throw afe;
        }
        this.loadedValues = this.loadValues(this.staticConfig, this.problems).getValueMapWithContextImmutable();
        this.doPropertyValidations(this.staticConfig, this.loadedValues, this.problems);
        this.checkForValuesWhichMustBeNonNull(this.staticConfig, this.problems);
        if (this.problems.size() > 0) {
            AppFatalException afe = AndHowUtil.buildFatalException(this.problems);
            this.printFailedStartupDetails(afe);
            throw afe;
        }
        List<ExportGroup> exportGroups = this.staticConfig.getExportGroups();
        for (ExportGroup eg : exportGroups) {
            Exporter exporter = eg.getExporter();
            GroupProxy group = eg.getGroup();
            if (group != null) {
                exporter.export(group, this.staticConfig, this);
                continue;
            }
            for (GroupProxy grp : this.staticConfig.getPropertyGroups()) {
                exporter.export(grp, this.staticConfig, this);
            }
        }
        if (this.getValue(Options.CREATE_SAMPLES).booleanValue()) {
            ReportGenerator.printConfigSamples(this.staticConfig, loaders, false);
        }
    }

    private void printFailedStartupDetails(AppFatalException afe) {
        File sampleDir = ReportGenerator.printConfigSamples(this.staticConfig, this.loaders, true);
        String sampleDirStr = sampleDir != null ? sampleDir.getAbsolutePath() : "";
        afe.setSampleDirectory(sampleDirStr);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ReportGenerator.printProblems(ps, afe, this.staticConfig);
        try {
            String message = os.toString("UTF8");
            System.err.println(System.lineSeparator() + message);
        }
        catch (UnsupportedEncodingException ex) {
            ReportGenerator.printProblems(System.err, afe, this.staticConfig);
        }
    }

    @Override
    public boolean isExplicitlySet(Property<?> prop) {
        return this.loadedValues.isExplicitlySet(prop);
    }

    @Override
    public <T> T getExplicitValue(Property<T> prop) {
        return this.loadedValues.getExplicitValue(prop);
    }

    @Override
    public <T> T getValue(Property<T> prop) {
        return this.loadedValues.getValue(prop);
    }

    private ValidatedValuesWithContext loadValues(StaticPropertyConfigurationInternal config, ProblemList<Problem> problems) {
        ValidatedValuesWithContextMutable existingValues = new ValidatedValuesWithContextMutable();
        for (Loader loader : this.loaders) {
            LoaderValues result = loader.load(config, existingValues);
            existingValues.addValues(result);
            problems.addAll(result.getProblems());
            loader.releaseResources();
        }
        return existingValues;
    }

    private void doPropertyValidations(StaticPropertyConfigurationInternal config, ValidatedValuesWithContext loadedValues, ProblemList<Problem> problems) {
        for (LoaderValues lvs : loadedValues.getAllLoaderValues()) {
            for (ValidatedValue pv : lvs.getValues()) {
                this.doPropertyValidation(config, lvs.getLoader(), problems, pv);
            }
        }
    }

    private <T> void doPropertyValidation(StaticPropertyConfigurationInternal config, Loader loader, ProblemList<Problem> problems, ValidatedValue<T> propValue) {
        Property<T> prop = propValue.getProperty();
        for (Validator<T> v : prop.getValidators()) {
            if (v.isValid(propValue.getValue())) continue;
            ValueProblem.InvalidValueProblem<T> problem = new ValueProblem.InvalidValueProblem<T>(loader, config.getGroupForProperty(prop).getProxiedGroup(), prop, propValue.getValue(), v);
            propValue.addProblem(problem);
            problems.add(problem);
        }
    }

    private void checkForValuesWhichMustBeNonNull(StaticPropertyConfigurationInternal config, ProblemList<Problem> problems) {
        for (Property<?> prop : config.getProperties()) {
            if (!prop.isNonNullRequired() || this.getValue(prop) != null) continue;
            problems.add(new RequirementProblem.NonNullPropertyProblem(config.getGroupForProperty(prop).getProxiedGroup(), prop));
        }
    }

    @Override
    public List<EffectiveName> getAliases(Property<?> property) {
        return this.staticConfig.getAliases(property);
    }

    @Override
    public String getCanonicalName(Property<?> prop) {
        return this.staticConfig.getCanonicalName(prop);
    }

    @Override
    public GroupProxy getGroupForProperty(Property<?> prop) {
        return this.staticConfig.getGroupForProperty(prop);
    }

    @Override
    public List<Property<?>> getPropertiesForGroup(GroupProxy group) {
        return this.staticConfig.getPropertiesForGroup(group);
    }

    @Override
    public Property<?> getProperty(String name) {
        return this.staticConfig.getProperty(name);
    }

    @Override
    public List<GroupProxy> getPropertyGroups() {
        return this.staticConfig.getPropertyGroups();
    }

    @Override
    public boolean containsUserGroups() {
        return this.staticConfig.containsUserGroups();
    }

    @Override
    public List<Property<?>> getProperties() {
        return this.staticConfig.getProperties();
    }

    @Override
    public List<ExportGroup> getExportGroups() {
        return this.staticConfig.getExportGroups();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.staticConfig.getNamingStrategy();
    }
}

