/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.LoaderValueCoord;
import org.yarnandtail.andhow.internal.PropertyCoord;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class LoaderProblem
implements Problem {
    protected LoaderValueCoord badValueCoord;

    public PropertyCoord getBadValueCoord() {
        return this.badValueCoord;
    }

    @Override
    public String getFullMessage() {
        return this.getProblemContext() + ": " + this.getProblemDescription();
    }

    @Override
    public String getProblemContext() {
        String loadDesc = null;
        String loadName = null;
        String propName = null;
        if (this.badValueCoord != null) {
            if (this.badValueCoord.getGroup() != null && this.badValueCoord.getProperty() != null) {
                propName = this.badValueCoord.getPropName();
            }
            if (this.badValueCoord.getLoader() != null) {
                loadName = this.badValueCoord.getLoader().getClass().getCanonicalName();
                if (this.badValueCoord.getLoader().getSpecificLoadDescription() != null) {
                    loadDesc = this.badValueCoord.getLoader().getSpecificLoadDescription();
                }
            }
            if (loadDesc != null) {
                if (propName != null) {
                    return TextUtil.format("Reading property {} from {}", propName, loadDesc);
                }
                return TextUtil.format("Reading from {}", loadDesc);
            }
            if (loadName != null) {
                if (propName != null) {
                    return TextUtil.format("Reading property {} via loader {}", propName, loadName);
                }
                return TextUtil.format("Reading via loader {}", loadDesc);
            }
            if (propName != null) {
                return TextUtil.format("Reading property {}", loadDesc);
            }
            return "[[Unknown]] context";
        }
        return "[[Unknown]] context";
    }

    public static class StringConversionLoaderProblem
    extends LoaderProblem {
        String str;

        public StringConversionLoaderProblem(Loader loader, Class<?> group, Property prop, String str) {
            this.badValueCoord = new LoaderValueCoord(loader, group, prop);
            this.str = str;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("The string '{}' could not be converted to type {}", this.str != null ? this.str : "[[NULL]]", this.getBadValueCoord().getProperty().getValueType().getDestinationType().getSimpleName());
        }
    }

    public static class ObjectConversionValueProblem
    extends LoaderProblem {
        Object obj;

        public ObjectConversionValueProblem(Loader loader, Class<?> group, Property prop, Object obj) {
            this.badValueCoord = new LoaderValueCoord(loader, group, prop);
            this.obj = obj;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("The object '{}' could not be converted to type {}", this.obj != null ? this.obj : "[[NULL]]", this.getBadValueCoord().getProperty().getValueType().getDestinationType().getSimpleName());
        }
    }

    public static class JndiContextLoaderProblem
    extends LoaderProblem {
        public JndiContextLoaderProblem(Loader loader) {
            this.badValueCoord = new LoaderValueCoord(loader, null, null);
        }

        @Override
        public String getProblemDescription() {
            return "Constructing the JNDI Context for the JndiLoader threw an Exception.  If there is no JNDI Context availabler for this entry point to the application, remove the JndiLoader from the list of Loaders.";
        }
    }

    public static class SourceNotFoundLoaderProblem
    extends LoaderProblem {
        String message;

        public SourceNotFoundLoaderProblem(Loader loader, String message) {
            this.badValueCoord = new LoaderValueCoord(loader, null, null);
            this.message = message;
        }

        @Override
        public String getProblemDescription() {
            return "Expected for find data for this loader to load from: " + this.message;
        }
    }

    public static class UnknownPropertyLoaderProblem
    extends LoaderProblem {
        private String unknownPropName;

        public UnknownPropertyLoaderProblem(Loader loader, String unknownPropName) {
            this.badValueCoord = new LoaderValueCoord(loader, null, null);
            this.unknownPropName = unknownPropName;
        }

        public String getUnknownPropertyName() {
            return this.unknownPropName;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("The property '{}' is not recognized", this.unknownPropName);
        }
    }

    public static class DuplicatePropertyLoaderProblem
    extends LoaderProblem {
        public DuplicatePropertyLoaderProblem(Loader loader, Class<?> group, Property prop) {
            this.badValueCoord = new LoaderValueCoord(loader, group, prop);
        }

        @Override
        public String getProblemDescription() {
            return "There are multiple values assigned to this property";
        }
    }

    public static class ParsingLoaderProblem
    extends LoaderProblem {
        Exception exception;

        public ParsingLoaderProblem(Loader loader, Class<?> group, Property prop, Exception exception) {
            this.badValueCoord = new LoaderValueCoord(loader, group, prop);
            this.exception = exception;
        }

        @Override
        public String getProblemDescription() {
            return this.exception.getMessage();
        }
    }

    public static class IOLoaderProblem
    extends LoaderProblem {
        Exception exception;
        String resourcePath;

        public IOLoaderProblem(Loader loader, Exception exception, String resourcePath) {
            this.badValueCoord = new LoaderValueCoord(loader, null, null);
            this.exception = exception;
        }

        @Override
        public String getProblemDescription() {
            return "There was an IO error while reading from: " + this.resourcePath + " Original error message: " + this.exception.getMessage();
        }
    }
}

