/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.yarnandtail.andhow.AndHowInit;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.compile.AndHowCompileException;
import org.yarnandtail.andhow.compile.AndHowElementScanner7;
import org.yarnandtail.andhow.compile.CompileProblem;
import org.yarnandtail.andhow.compile.CompileUnit;
import org.yarnandtail.andhow.compile.PropertyRegistrarClassGenerator;
import org.yarnandtail.andhow.service.PropertyRegistrar;
import org.yarnandtail.andhow.service.PropertyRegistrationList;
import org.yarnandtail.andhow.util.TextUtil;

@SupportedAnnotationTypes(value={"*"})
public class AndHowCompileProcessor
extends AbstractProcessor {
    private static final String INIT_CLASS_NAME = AndHowInit.class.getCanonicalName();
    private static final String TEST_INIT_CLASS_NAME = "org.yarnandtail.andhow.AndHowTestInit";
    private static final String SERVICES_PACKAGE = "";
    private static final String SERVICE_REGISTRY_META_DIR = "META-INF/services/";
    private static Calendar runDate;
    private final List<CauseEffect> registrars = new ArrayList<CauseEffect>();
    private final List<CauseEffect> initClasses = new ArrayList<CauseEffect>();
    private final List<CauseEffect> testInitClasses = new ArrayList<CauseEffect>();
    private final List<CompileProblem> problems = new ArrayList<CompileProblem>();

    public AndHowCompileProcessor() {
        runDate = new GregorianCalendar();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(this.unwrap(processingEnv));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        Messager log = this.processingEnv.getMessager();
        boolean isLastRound = roundEnv.processingOver();
        if (isLastRound) {
            this.debug(log, "Final round of annotation processing. Total root element count: {}", roundEnv.getRootElements().size());
            if (this.initClasses.size() > 1) {
                this.problems.add(new CompileProblem.TooManyInitClasses(INIT_CLASS_NAME, this.initClasses));
            }
            if (this.testInitClasses.size() > 1) {
                this.problems.add(new CompileProblem.TooManyInitClasses(TEST_INIT_CLASS_NAME, this.testInitClasses));
            }
            if (this.problems.isEmpty()) {
                try {
                    if (this.initClasses.size() == 1) {
                        this.debug(log, "Found exactly 1 {} class: {}", INIT_CLASS_NAME, this.initClasses.get((int)0).fullClassName);
                        this.writeServiceFile(filer, AndHowInit.class.getCanonicalName(), this.initClasses);
                    }
                    if (this.testInitClasses.size() == 1) {
                        this.debug(log, "Found exactly 1 {} class: {}", TEST_INIT_CLASS_NAME, this.testInitClasses.get((int)0).fullClassName);
                        this.writeServiceFile(filer, TEST_INIT_CLASS_NAME, this.testInitClasses);
                    }
                    if (this.registrars.size() <= 0) return false;
                    this.writeServiceFile(filer, PropertyRegistrar.class.getCanonicalName(), this.registrars);
                    return false;
                }
                catch (IOException e) {
                    throw new AndHowCompileException("Exception while trying to write generated files", e);
                }
            }
            this.error(log, "AndHow Property definition or Init class errors prevented compilation. Each of the following errors must be fixed before compilation is possible.", new Object[0]);
            this.error(log, "AndHow errors discovered: {}", this.problems.size());
            for (CompileProblem err : this.problems) {
                this.error(log, err.getFullMessage(), new Object[0]);
            }
            throw new AndHowCompileException(this.problems);
        }
        this.debug(log, "Another round of annotation processing. Current root element count: {}", roundEnv.getRootElements().size());
        Iterator<? extends Element> it = roundEnv.getRootElements().iterator();
        for (Element element : roundEnv.getRootElements()) {
            TypeElement te = (TypeElement)element;
            AndHowElementScanner7 st = new AndHowElementScanner7(this.processingEnv, Property.class.getCanonicalName(), INIT_CLASS_NAME, TEST_INIT_CLASS_NAME);
            CompileUnit ret = (CompileUnit)st.scan(element);
            if (ret.istestInitClass()) {
                this.testInitClasses.add(new CauseEffect(ret.getRootCanonicalName(), te));
            } else if (ret.isInitClass()) {
                this.initClasses.add(new CauseEffect(ret.getRootCanonicalName(), te));
            }
            if (ret.hasRegistrations()) {
                this.debug(log, "Found {} AndHow Properties in class {} ", ret.getRegistrations().size(), ret.getRootCanonicalName());
                PropertyRegistrarClassGenerator gen = new PropertyRegistrarClassGenerator(ret, AndHowCompileProcessor.class, runDate);
                this.registrars.add(new CauseEffect(gen.buildGeneratedClassFullName(), te));
                PropertyRegistrationList regs = ret.getRegistrations();
                try {
                    this.writeClassFile(filer, gen, element);
                    this.debug(log, "Wrote new generated class file {}", gen.buildGeneratedClassSimpleName());
                }
                catch (Exception ex) {
                    this.error(log, "Unable to write generated classfile '" + gen.buildGeneratedClassFullName() + "'", ex);
                    throw new RuntimeException(ex);
                }
            }
            this.problems.addAll(ret.getProblems());
        }
        return false;
    }

    public void writeClassFile(Filer filer, PropertyRegistrarClassGenerator generator, Element causingElement) throws Exception {
        String classContent = generator.generateSource();
        JavaFileObject classFile = filer.createSourceFile(generator.buildGeneratedClassFullName(), causingElement);
        try (Writer writer = classFile.openWriter();){
            writer.write(classContent);
        }
    }

    protected void writeServiceFile(Filer filer, String fullyQualifiedServiceInterfaceName, List<CauseEffect> implementingClasses) throws IOException {
        HashSet<Element> set = new HashSet<Element>();
        for (CauseEffect ce : implementingClasses) {
            set.add(ce.causeElement);
        }
        FileObject svsFile = filer.createResource(StandardLocation.CLASS_OUTPUT, SERVICES_PACKAGE, SERVICE_REGISTRY_META_DIR + fullyQualifiedServiceInterfaceName, set.toArray(new Element[set.size()]));
        try (Writer writer = svsFile.openWriter();){
            for (CauseEffect ce : implementingClasses) {
                writer.write(ce.fullClassName);
                writer.write(System.lineSeparator());
            }
        }
    }

    void debug(Messager log, String pattern, Object ... args) {
        log.printMessage(Diagnostic.Kind.NOTE, TextUtil.format(pattern, args));
    }

    void error(Messager log, String pattern, Object ... args) {
        log.printMessage(Diagnostic.Kind.ERROR, TextUtil.format(pattern, args));
    }

    private ProcessingEnvironment unwrap(ProcessingEnvironment processingEnv) {
        if (Proxy.isProxyClass(processingEnv.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(processingEnv);
            try {
                Field field = invocationHandler.getClass().getDeclaredField("val$delegateTo");
                field.setAccessible(true);
                Object o = field.get(invocationHandler);
                if (o instanceof ProcessingEnvironment) {
                    return (ProcessingEnvironment)o;
                }
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "got " + o.getClass() + " expected instanceof com.sun.tools.javac.processing.JavacProcessingEnvironment");
                return null;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                return null;
            }
        }
        return processingEnv;
    }

    protected static class CauseEffect {
        String fullClassName;
        Element causeElement;

        public CauseEffect(String fullClassName, Element causeElement) {
            this.fullClassName = fullClassName;
            this.causeElement = causeElement;
        }
    }
}

