/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import com.sun.source.util.Trees;
import java.util.logging.Level;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner7;
import javax.lang.model.util.Types;
import org.yarnandtail.andhow.compile.CompileUnit;
import org.yarnandtail.andhow.compile.PropertyMarker;
import org.yarnandtail.andhow.compile.PropertyVariableTreeScanner;
import org.yarnandtail.andhow.util.AndHowLog;
import org.yarnandtail.andhow.util.NameUtil;

public class AndHowElementScanner7
extends ElementScanner7<CompileUnit, String> {
    private static final AndHowLog LOG = AndHowLog.getLogger(AndHowElementScanner7.class);
    private final Types typeUtils;
    private final TypeMirror propertyTypeMirror;
    private final TypeMirror initTypeMirror;
    private final TypeMirror testInitTypeMirror;
    private final Trees trees;
    CompileUnit compileUnit;

    public AndHowElementScanner7(ProcessingEnvironment processingEnv, String typeNameOfAndHowProperty, String typeNameOfAndHowInit, String typeNameOfAndHowTestInit) {
        super(null);
        this.trees = Trees.instance(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        TypeElement propertyTypeElem = processingEnv.getElementUtils().getTypeElement(typeNameOfAndHowProperty);
        this.propertyTypeMirror = propertyTypeElem.asType();
        TypeElement initTypeElem = processingEnv.getElementUtils().getTypeElement(typeNameOfAndHowInit);
        this.initTypeMirror = initTypeElem.asType();
        TypeElement testInitTypeElem = processingEnv.getElementUtils().getTypeElement(typeNameOfAndHowTestInit);
        this.testInitTypeMirror = testInitTypeElem != null ? testInitTypeElem.asType() : null;
    }

    @Override
    public CompileUnit visitVariable(VariableElement e, String p) {
        boolean isPropType = this.typeUtils.isAssignable(this.typeUtils.erasure(e.asType()), this.typeUtils.erasure(this.propertyTypeMirror));
        if (isPropType) {
            PropertyVariableTreeScanner ts = new PropertyVariableTreeScanner();
            PropertyMarker marker = new PropertyMarker();
            ts.scan(this.trees.getPath(e), marker);
            if (marker.isNewProperty()) {
                this.compileUnit.addProperty(e.getSimpleName().toString(), e.getModifiers().contains((Object)Modifier.STATIC), e.getModifiers().contains((Object)Modifier.FINAL));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.debug("Found creating of an AndHow Property in source code: {0}", NameUtil.getAndHowName(this.compileUnit.getRootCanonicalName(), e.getSimpleName().toString(), this.compileUnit.getInnerPathNames()));
                }
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.trace("Found an AndHow Property variable ''{0}'' in ''{1}'', but it is just a reference to an existing property.", e.getSimpleName().toString(), this.compileUnit.getRootCanonicalName());
            }
        }
        return this.compileUnit;
    }

    @Override
    public CompileUnit visitType(TypeElement e, String p) {
        if (this.compileUnit == null) {
            this.compileUnit = new CompileUnit(e.getQualifiedName().toString());
            if (e.getKind().equals((Object)ElementKind.CLASS) && !e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                if (this.testInitTypeMirror != null && this.typeUtils.isAssignable(this.typeUtils.erasure(e.asType()), this.typeUtils.erasure(this.testInitTypeMirror))) {
                    this.compileUnit.setTestInitClass(true);
                } else if (this.typeUtils.isAssignable(this.typeUtils.erasure(e.asType()), this.typeUtils.erasure(this.initTypeMirror))) {
                    this.compileUnit.setInitClass(true);
                }
            }
            this.scan(ElementFilter.fieldsIn(e.getEnclosedElements()), p);
            this.scan(ElementFilter.typesIn(e.getEnclosedElements()), p);
        } else {
            this.compileUnit.pushType(e.getSimpleName().toString(), e.getModifiers().contains((Object)Modifier.STATIC));
            this.scan(ElementFilter.fieldsIn(e.getEnclosedElements()), p);
            this.scan(ElementFilter.typesIn(e.getEnclosedElements()), p);
            this.compileUnit.popType();
        }
        return this.compileUnit;
    }
}

