/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.yarnandtail.andhow.compile.AndHowCompileProcessor;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class CompileProblem {
    final String groupName;
    final String propName;
    final boolean propProblem;

    CompileProblem(String groupName, String propName) {
        this.groupName = groupName;
        this.propName = propName;
        this.propProblem = true;
    }

    CompileProblem() {
        this.groupName = null;
        this.propName = null;
        this.propProblem = false;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public boolean isPropertyProblem() {
        return this.propProblem;
    }

    public boolean equals(Object o) {
        if (o != null && this.getClass().isInstance(o)) {
            CompileProblem cp = (CompileProblem)o;
            return this.groupName.equals(cp.groupName) && this.propName.equals(cp.propName) && this.propProblem == cp.propProblem;
        }
        return false;
    }

    public abstract String getFullMessage();

    static class TooManyInitClasses
    extends CompileProblem {
        private final List<AndHowCompileProcessor.CauseEffect> _instances = new ArrayList<AndHowCompileProcessor.CauseEffect>();
        private final String _fullInitClassName;

        public TooManyInitClasses(String fullInitClassName, List<AndHowCompileProcessor.CauseEffect> instances) {
            if (instances != null) {
                this._instances.addAll(instances);
            }
            this._fullInitClassName = fullInitClassName;
        }

        public List<String> getInstanceNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (AndHowCompileProcessor.CauseEffect ce : this._instances) {
                names.add(ce.fullClassName);
            }
            return names;
        }

        public String getInitClassName() {
            return this._fullInitClassName;
        }

        @Override
        public String getFullMessage() {
            String impList = this._instances.stream().map(i -> i.fullClassName).collect(Collectors.joining(", "));
            return TextUtil.format("Multiple ({}) implementations of {} were found, but only one is allowed.  Implementations found: {}", String.valueOf(this._instances.size()), this._fullInitClassName, impList);
        }

        @Override
        public boolean equals(Object o) {
            if (o != null && this.getClass().isInstance(o)) {
                TooManyInitClasses cp = (TooManyInitClasses)o;
                return this._instances.containsAll(cp._instances) && cp._instances.containsAll(this._instances) && this._fullInitClassName.equals(cp._fullInitClassName);
            }
            return false;
        }
    }

    static class PropMissingStaticFinal
    extends CompileProblem {
        public PropMissingStaticFinal(String groupName, String propName) {
            super(groupName, propName);
        }

        @Override
        public String getFullMessage() {
            return TextUtil.format("The AndHow Property '{}' in the class '{}' must be declared as final.", this.groupName, this.propName);
        }
    }

    static class PropMissingFinal
    extends CompileProblem {
        public PropMissingFinal(String groupName, String propName) {
            super(groupName, propName);
        }

        @Override
        public String getFullMessage() {
            return TextUtil.format("The AndHow Property '{}' in the class '{}' must be declared as final.", this.groupName, this.propName);
        }
    }

    static class PropMissingStatic
    extends CompileProblem {
        public PropMissingStatic(String groupName, String propName) {
            super(groupName, propName);
        }

        @Override
        public String getFullMessage() {
            return TextUtil.format("The AndHow Property '{}' in the class '{}' must be declared as static.", this.groupName, this.propName);
        }
    }
}

