/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

public class CompileUtil {
    public static String getGeneratedAnnotationClassName() {
        return CompileUtil.getGeneratedAnnotationClassName(CompileUtil.getMajorJavaVersion(System.getProperty("java.version")));
    }

    public static String getGeneratedAnnotationClassName(int javaMajorVersion) {
        if (javaMajorVersion < 9) {
            return "javax.annotation.Generated";
        }
        return "javax.annotation.processing.Generated";
    }

    public static int getMajorJavaVersion(String versionString) {
        String[] versionParts = versionString.split("[\\.\\-_]", 3);
        try {
            if ("1".equals(versionParts[0])) {
                return Integer.parseInt(versionParts[1]);
            }
            return Integer.parseInt(versionParts[0]);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("AndHow couldn't parse '" + versionString + "' as a 'java.version' string in System.properties. Is this a non-standard JDK? ", e);
        }
    }
}

