/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.yarnandtail.andhow.compile.CompileUnit;
import org.yarnandtail.andhow.compile.CompileUtil;
import org.yarnandtail.andhow.service.PropertyRegistrar;
import org.yarnandtail.andhow.service.PropertyRegistration;
import org.yarnandtail.andhow.service.PropertyRegistrationList;
import org.yarnandtail.andhow.util.IOUtil;

public class PropertyRegistrarClassGenerator {
    private final CompileUnit compUnit;
    private final Class<?> generatingClass;
    private final Calendar runDate;
    private final SimpleDateFormat dateFormat;

    public PropertyRegistrarClassGenerator(CompileUnit compUnit, Class<?> generatingClass, Calendar runDate) {
        this.compUnit = compUnit;
        this.generatingClass = generatingClass;
        this.runDate = runDate;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    public String getTemplatePath() {
        return "/" + PropertyRegistrarClassGenerator.class.getCanonicalName().replace(".", "/") + "_Template.txt";
    }

    public String getTemplate() throws Exception {
        return IOUtil.getUTF8ResourceAsString(this.getTemplatePath());
    }

    public String generateSource() throws Exception {
        String template = this.getTemplate();
        String source = String.format(template, this.buildPackageString(), this.compUnit.getRootCanonicalName(), this.compUnit.getRootSimpleName(), this.buildGeneratedClassSimpleName(), PropertyRegistrar.class.getCanonicalName(), this.generatingClass.getCanonicalName(), this.buildRunDateString(), this.buildRegistrationAddsString(), CompileUtil.getGeneratedAnnotationClassName());
        return source;
    }

    protected String buildPackageString() {
        if (this.compUnit.getRootPackageName() != null) {
            return "package " + this.compUnit.getRootPackageName() + ";";
        }
        return "";
    }

    protected String buildGeneratedClassSimpleName() {
        return "$" + this.compUnit.getRootSimpleName() + "_AndHowProps";
    }

    protected String buildGeneratedClassFullName() {
        if (this.compUnit.getRootPackageName() != null) {
            return this.compUnit.getRootPackageName() + "." + this.buildGeneratedClassSimpleName();
        }
        return this.buildGeneratedClassSimpleName();
    }

    protected String buildRunDateString() {
        return this.dateFormat.format(this.runDate.getTime());
    }

    protected String buildRegistrationAddsString() {
        StringBuilder buf = new StringBuilder();
        PropertyRegistrationList regList = this.compUnit.getRegistrations();
        regList.sort();
        PropertyRegistration prevReg = null;
        for (PropertyRegistration pr : regList) {
            if (prevReg != null && pr.compareInnerPathTo(prevReg) != 0 || prevReg == null && pr.getInnerPathLength() > 0) {
                buf.append("\t\tlist.add(\"").append(pr.getPropertyName()).append("\"");
                for (String step : pr.getInnerPath()) {
                    buf.append(", \"").append(step).append("\"");
                }
                buf.append(");").append(System.lineSeparator());
            } else {
                buf.append("\t\tlist.add(\"").append(pr.getPropertyName()).append("\");").append(System.lineSeparator());
            }
            prevReg = pr;
        }
        return buf.toString();
    }
}

