/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.export;

import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.Exporter;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValidatedValues;
import org.yarnandtail.andhow.internal.StaticPropertyConfigurationInternal;

public abstract class BaseExporter
implements Exporter {
    protected Exporter.EXPORT_CANONICAL_NAME includeCanonical;
    protected Exporter.EXPORT_OUT_ALIASES includeOutAlias;

    @Override
    public void setExportByOutAliases(Exporter.EXPORT_OUT_ALIASES option) {
        if (option == null) {
            throw new AppFatalException("The export alias option cannot be null");
        }
        this.includeOutAlias = option;
    }

    @Override
    public void setExportByCanonicalName(Exporter.EXPORT_CANONICAL_NAME option) {
        if (option == null) {
            throw new AppFatalException("The canonical name option cannot be null");
        }
        this.includeCanonical = option;
    }

    public abstract <T> void doExport(String var1, Property<T> var2, StaticPropertyConfigurationInternal var3, ValidatedValues var4);

    @Override
    public void export(StaticPropertyConfigurationInternal definition, ValidatedValues values) {
        for (GroupProxy pg : definition.getPropertyGroups()) {
            this.export(pg, definition, values);
        }
    }

    @Override
    public void export(GroupProxy group, StaticPropertyConfigurationInternal definition, ValidatedValues values) {
        List<Property<?>> props = definition.getPropertiesForGroup(group);
        for (Property<?> prop : props) {
            this.export(prop, definition, values);
        }
    }

    public void export(Property<?> property, StaticPropertyConfigurationInternal definition, ValidatedValues values) {
        ArrayList<String> names = new ArrayList<String>();
        boolean exportCanon = false;
        boolean exportAlias = false;
        boolean hasOut = this.hasOutAlias(property, definition);
        if (Exporter.EXPORT_OUT_ALIASES.ALWAYS.equals((Object)this.includeOutAlias) && hasOut) {
            exportAlias = true;
        }
        if (Exporter.EXPORT_CANONICAL_NAME.ALWAYS.equals((Object)this.includeCanonical)) {
            exportCanon = true;
        } else if (Exporter.EXPORT_CANONICAL_NAME.NEVER.equals((Object)this.includeCanonical)) {
            exportCanon = false;
        } else {
            boolean bl = exportCanon = !hasOut;
        }
        if (exportCanon) {
            names.add(definition.getCanonicalName(property));
        }
        if (exportAlias) {
            definition.getAliases(property).stream().filter(a -> a.isOut()).forEachOrdered(a -> names.add(a.getActualName()));
        }
        names.stream().forEach(n -> this.doExport((String)n, property, definition, values));
    }

    protected boolean hasOutAlias(Property<?> property, StaticPropertyConfigurationInternal definition) {
        List<EffectiveName> aliases = definition.getAliases(property);
        for (EffectiveName a : aliases) {
            if (!a.isOut()) continue;
            return true;
        }
        return false;
    }
}

