/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.AndHow;
import org.yarnandtail.andhow.AndHowInit;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.internal.PropertyCoord;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class ConstructionProblem
implements Problem {
    protected PropertyCoord badPropertyCoord;
    protected PropertyCoord refPropertyCoord;

    public PropertyCoord getRefPropertyCoord() {
        return this.refPropertyCoord;
    }

    public PropertyCoord getBadPropertyCoord() {
        return this.badPropertyCoord;
    }

    @Override
    public String getProblemContext() {
        if (this.badPropertyCoord != null) {
            return TextUtil.format("Property {}", this.badPropertyCoord.getPropName());
        }
        return "[[Unknown]]";
    }

    @Override
    public String getFullMessage() {
        return this.getProblemContext() + ": " + this.getProblemDescription();
    }

    public static class InitiationLoopException
    extends ConstructionProblem {
        AndHow.Initialization originalInit;
        AndHow.Initialization secondInit;

        public InitiationLoopException(AndHow.Initialization originalInit, AndHow.Initialization secondInit) {
            this.originalInit = originalInit;
            this.secondInit = secondInit;
        }

        public AndHow.Initialization getOriginalInit() {
            return this.originalInit;
        }

        public AndHow.Initialization getSecondInit() {
            return this.secondInit;
        }

        @Override
        public String getProblemDescription() {
            return "AndHow detected a loop during initiation.  Likely causes are: " + System.lineSeparator() + "- Multiple places in application code where AndHow.instance(AndHowConfiguration) is called" + System.lineSeparator() + "- static initiation blocks or static variables that are initiated refering to the value of an AndHow Property" + System.lineSeparator() + "- AndHow Properties that refer to the value of other AndHow properties in their construction" + System.lineSeparator() + "::The first line in the stack trace following this error referring to your application code is likely causing the initiation loop::";
        }

        @Override
        public String getFullMessage() {
            return this.getProblemDescription();
        }
    }

    public static class TooManyAndHowInitInstances
    extends ConstructionProblem {
        List<String> names = new ArrayList<String>();

        public TooManyAndHowInitInstances(List<? extends AndHowInit> instances) {
            for (AndHowInit andHowInit : instances) {
                this.names.add(andHowInit.getClass().getCanonicalName());
            }
        }

        public List<String> getInstanceNames() {
            return this.names;
        }

        @Override
        public String getProblemDescription() {
            String joined = String.join((CharSequence)", ", this.names);
            return TextUtil.format("There can be only be one instance each of {} and AndHowTestInit on the classpath, but multiple were found: {}", AndHowInit.class.getCanonicalName(), joined);
        }
    }

    public static class InvalidValidationConfiguration
    extends ConstructionProblem {
        Validator<?> valid;

        public InvalidValidationConfiguration(GroupProxy group, Property<?> property, Validator<?> valid) {
            this.badPropertyCoord = new PropertyCoord(group.getProxiedGroup(), property);
            this.valid = valid;
        }

        public Validator<?> getValidator() {
            return this.valid;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Has a Validator of type {} that is not configured correctly: {}", this.valid.getClass().getSimpleName(), this.valid.getInvalidSpecificationMessage());
        }
    }

    public static class InvalidDefaultValue
    extends ConstructionProblem {
        String invalidMessage;

        public InvalidDefaultValue(GroupProxy group, Property<?> prop, String invalidMessage) {
            this.badPropertyCoord = new PropertyCoord(group.getProxiedGroup(), prop);
            this.invalidMessage = invalidMessage;
        }

        public String getInvalidMessage() {
            return this.invalidMessage;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Has a default value that does not pass validation: {}", this.invalidMessage);
        }
    }

    public static class ExportException
    extends ConstructionProblem {
        Exception exception;
        String message;

        public ExportException(Exception exception, GroupProxy group, String message) {
            this.exception = exception;
            this.message = message;
            this.badPropertyCoord = new PropertyCoord(group.getProxiedGroup(), null);
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("PropertyGroup {}", this.badPropertyCoord.getGroup().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("An error occured while initiating the value export.  The message was: {}", this.message);
        }
    }

    public static class PropertyNotPartOfGroup
    extends ConstructionProblem {
        public PropertyNotPartOfGroup(GroupProxy group, Property<?> prop) {
            this.badPropertyCoord = new PropertyCoord(group.getProxiedGroup(), prop);
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("This property is not part of the group its is being added to.", new Object[0]);
        }
    }

    public static class SecurityException
    extends ConstructionProblem {
        Exception exception;

        public SecurityException(Exception exception, Class<?> group) {
            this.exception = exception;
            this.badPropertyCoord = new PropertyCoord(group, null);
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("PropertyGroup {}", this.badPropertyCoord.getGroup().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("A security exception was thrown while trying to read class members.  {} must read PropertyGroup class members via reflection to build Property names. To fix, Properties must either be public or the JVM security policies that are preventing reflection visibility must be disabled.", "AndHow");
        }
    }

    public static class LoaderPropertyNotRegistered
    extends ConstructionProblem {
        Loader loader;
        Property property;

        public LoaderPropertyNotRegistered(Loader loader, Property property) {
            this.loader = loader;
            this.property = property;
        }

        public Loader getLoader() {
            return this.loader;
        }

        public Property getProperty() {
            return this.property;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("{} loader's {} property of type {}", this.loader.getClass().getSimpleName(), this.property.getClass().getSimpleName(), this.property.getValueType().getDestinationType().getSimpleName());
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("This loader has a {} property passed in its constructor, but the property is not part of any of the PropertyGroups added during AndHow's initiation. Ensure the property is declared in a PropertyGroup and that the group is added to AndHow in its initiation.", this.property.getClass().getSimpleName());
        }
    }

    public static class LoaderPropertyIsNull
    extends ConstructionProblem {
        Loader loader;

        public LoaderPropertyIsNull(Loader loader) {
            this.loader = loader;
        }

        public Loader getLoader() {
            return this.loader;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("{} loader", this.loader.getClass().getSimpleName());
        }

        @Override
        public String getProblemDescription() {
            return "This loader expects a Property passed in its constructor, however, a null value was passed.  This is not a property pointing to null configuration value - The actual reference to the property is null. ";
        }
    }

    public static class DuplicateLoader
    extends ConstructionProblem {
        Loader loader;

        public DuplicateLoader(Loader loader) {
            this.loader = loader;
        }

        public Loader getLoader() {
            return this.loader;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("Multiple loaders of type {}", this.loader.getClass().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return "The same Loader instance has been added multiple times. Loaders of the same type are allowed, but they must be separate instances.";
        }
    }

    public static class DuplicateProperty
    extends ConstructionProblem {
        public DuplicateProperty(GroupProxy refGroup, Property<?> refProperty, GroupProxy badGroup, Property<?> badProperty) {
            this.refPropertyCoord = new PropertyCoord(refGroup.getProxiedGroup(), refProperty);
            this.badPropertyCoord = new PropertyCoord(badGroup.getProxiedGroup(), badProperty);
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Is the same instance as {} - The containing PropertyGroups are sharing a reference to the same Property instance.  Properties must each be independant instances because they each identify unique values.", this.refPropertyCoord.getPropName());
        }
    }

    public static class NonUniqueNames
    extends ConstructionProblem {
        String conflictName;

        public NonUniqueNames(GroupProxy refGroup, Property<?> refProperty, GroupProxy badGroup, Property<?> badProperty, String conflictName) {
            this.refPropertyCoord = new PropertyCoord(refGroup.getProxiedGroup(), refProperty);
            this.badPropertyCoord = new PropertyCoord(badGroup.getProxiedGroup(), badProperty);
            this.conflictName = conflictName;
        }

        public String getConflictName() {
            return this.conflictName;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Has the name '{}' which is a name or alias in use by {}. All names must be unique and, for the BasicNamingStrategy, must be unique in a case insensitive way.", this.conflictName, this.refPropertyCoord.getPropName());
        }
    }
}

