/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.internal.StaticPropertyConfigurationInternal;
import org.yarnandtail.andhow.sample.BaseSamplePrinter;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.sample.PropFileFormat;
import org.yarnandtail.andhow.sample.TextBlock;
import org.yarnandtail.andhow.util.TextUtil;

public class PropFileLoaderSamplePrinter
extends BaseSamplePrinter
implements SamplePrinter {
    protected PrintFormat format = new PropFileFormat();

    @Override
    public PrintFormat getFormat() {
        return this.format;
    }

    @Override
    public TextBlock getSampleFileStart() {
        return null;
    }

    @Override
    public TextBlock getSampleStartComment(StaticPropertyConfigurationInternal definition) {
        TextBlock tb = new TextBlock(true, true);
        tb.addHR();
        tb.addLine("Sample properties file generated by AndHow!");
        tb.addLine("strong.simple.valid.AppConfiguration  -  https://github.com/eeverman/andhow");
        tb.addLine("Note: " + definition.getNamingStrategy().getNameMatchingDescription());
        tb.addHR();
        return tb;
    }

    @Override
    public String getInAliaseString(StaticPropertyConfigurationInternal definition, EffectiveName name) {
        return name.getActualName();
    }

    @Override
    public TextBlock getActualProperty(StaticPropertyConfigurationInternal definition, GroupProxy group, Property prop) throws Exception {
        TextBlock tb = new TextBlock(false, false);
        String propCanonName = group.getCanonicalName(prop);
        if (prop.getDefaultValue() != null) {
            tb.addLine(TextUtil.format("{} = {}", propCanonName, prop.getDefaultValue()));
        } else {
            tb.addLine(TextUtil.format("{} = [{}]", propCanonName, prop.getValueType().getDestinationType().getSimpleName()));
        }
        return tb;
    }

    @Override
    public TextBlock getSampleFileEnd() {
        return null;
    }

    @Override
    public String getSampleFileExtension() {
        return "properties";
    }
}

