/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.yarnandtail.andhow.AndHowConfiguration;
import org.yarnandtail.andhow.AndHowInit;

public class InitLoader {
    private final ServiceLoader<AndHowInit> loader;
    private final Object lock = new Object();

    public InitLoader() {
        this(InitLoader.class.getClassLoader());
    }

    public InitLoader(ClassLoader classLoader) {
        ClassLoader cl = classLoader != null ? classLoader : InitLoader.class.getClassLoader();
        this.loader = ServiceLoader.load(AndHowInit.class, cl);
    }

    public boolean isValidState() {
        return this.getInitInstances().size() <= 1;
    }

    public boolean hasConfig() {
        return this.getInitInstances().size() > 0;
    }

    public AndHowConfiguration getAndHowConfiguration(AndHowConfiguration defaultConfig) {
        if (this.getInitInstances().size() == 1) {
            return this.getInitInstances().get(0).getConfiguration();
        }
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AndHowInit> getInitInstances() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<AndHowInit> list = new ArrayList<AndHowInit>();
            Iterator<AndHowInit> it = this.loader.iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            this.loader.reload();
        }
    }
}

