/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yarnandtail.andhow.util.AndHowLogHandler;
import org.yarnandtail.andhow.util.StackLocator;

public class AndHowLog {
    private static final AndHowLogHandler DEFAULT_HANDLER = new AndHowLogHandler();
    private static final String CN = AndHowLog.class.getCanonicalName();
    private final Class<?> clazz;
    private final Logger baseLogger;

    public static AndHowLog getLogger(Class<?> clazz) {
        Logger baseLog = Logger.getLogger(clazz.getCanonicalName());
        return new AndHowLog(baseLog, clazz);
    }

    public static AndHowLog getLogger(Class<?> clazz, Handler handler) {
        Logger baseLog = Logger.getLogger(clazz.getCanonicalName());
        return new AndHowLog(baseLog, clazz, handler);
    }

    private AndHowLog(Logger baseLog, Class<?> clazz) {
        this(baseLog, clazz, null);
    }

    private AndHowLog(Logger baseLog, Class<?> clazz, Handler handler) {
        Handler[] orgHandlers;
        this.baseLogger = baseLog;
        this.baseLogger.setUseParentHandlers(false);
        if (handler == null) {
            handler = DEFAULT_HANDLER;
        }
        for (Handler h : orgHandlers = this.baseLogger.getHandlers()) {
            this.baseLogger.removeHandler(h);
        }
        this.baseLogger.addHandler(handler);
        this.clazz = clazz;
        this.reloadLogLevel();
    }

    public void setLevel(Level newLevel) throws SecurityException {
        if (newLevel != null) {
            this.baseLogger.setLevel(newLevel);
        } else {
            this.reloadLogLevel();
        }
    }

    public Handler[] getHandlers() {
        return this.baseLogger.getHandlers();
    }

    public void addHandler(Handler handler) {
        this.baseLogger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.baseLogger.removeHandler(handler);
    }

    public boolean isLoggable(Level level) {
        return this.baseLogger.isLoggable(level);
    }

    private void reloadLogLevel() {
        String levelProp = this.clazz.getCanonicalName() + ".level";
        String levelStr = System.getProperty(levelProp);
        if (levelStr != null) {
            this.baseLogger.setLevel(Level.parse(levelStr));
        } else {
            this.baseLogger.setLevel(null);
        }
    }

    public void trace(String msg) {
        if (this.baseLogger.isLoggable(Level.FINEST)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.FINEST, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.baseLogger.isLoggable(Level.FINEST)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.FINEST, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.baseLogger.isLoggable(Level.FINEST)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.FINEST, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg, t);
        }
    }

    public void debug(String msg) {
        if (this.baseLogger.isLoggable(Level.FINE)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.FINE, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.baseLogger.isLoggable(Level.FINE)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.FINE, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.baseLogger.isLoggable(Level.FINE)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.FINE, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg, t);
        }
    }

    public void info(String msg) {
        if (this.baseLogger.isLoggable(Level.INFO)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.INFO, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.baseLogger.isLoggable(Level.INFO)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.INFO, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.baseLogger.isLoggable(Level.INFO)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.INFO, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg, t);
        }
    }

    public void warn(String msg) {
        if (this.baseLogger.isLoggable(Level.WARNING)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.WARNING, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.baseLogger.isLoggable(Level.WARNING)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.WARNING, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), format, arguments);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.baseLogger.isLoggable(Level.WARNING)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.WARNING, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg, t);
        }
    }

    public void error(String msg) {
        if (this.baseLogger.isLoggable(Level.SEVERE)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.SEVERE, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.baseLogger.isLoggable(Level.SEVERE)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.SEVERE, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.baseLogger.isLoggable(Level.SEVERE)) {
            StackTraceElement ste = StackLocator.calcLocation(CN);
            this.baseLogger.logp(Level.SEVERE, ste.getClassName(), ste.getMethodName() + ":" + ste.getLineNumber(), msg, t);
        }
    }
}

