package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.AndHow;
import org.yarnandtail.andhow.api.*;
import org.yarnandtail.andhow.util.TextUtil;

/**
 *
 * @author ericeverman
 */
public class PropFileLoaderSamplePrinter extends BaseSamplePrinter implements SamplePrinter {
	protected PrintFormat format = new PropFileFormat();

	public PropFileLoaderSamplePrinter() {
	}

	@Override
	public PrintFormat getFormat() {
		return format;
	}


	@Override
	public TextBlock getSampleFileStart() {
		return null;
	}

	@Override
	public TextBlock getSampleStartComment(PropertyConfigurationInternal definition) {
		TextBlock tb = new TextBlock(true, true);
		tb.addHR();
		tb.addLine("Sample properties file generated by " + AndHow.ANDHOW_NAME);
		tb.addLine(AndHow.ANDHOW_TAG_LINE + "  -  " + AndHow.ANDHOW_URL);
		tb.addLine("Note: "+ definition.getNamingStrategy().getNameMatchingDescription());
		tb.addHR();
		return tb;

	}

	@Override
	public String getInAliaseString(PropertyConfigurationInternal definition, EffectiveName name) {
		return name.getActualName();
	}

	@Override
	public TextBlock getActualProperty(PropertyConfigurationInternal definition,
                                       GroupProxy group, Property prop) throws Exception {

		TextBlock tb = new TextBlock(false, false);

		String propCanonName = group.getCanonicalName(prop);

		tb.addLine(
				TextUtil.format("{} = ", propCanonName)
		);

		return tb;
	}

	@Override
	public TextBlock getSampleFileEnd() {
		return null;
	}

	@Override
	public String getSampleFileExtension() {
		return "properties";
	}
}
